SELECT
	*
FROM
	(
		SELECT
			s.*,
			info.f_createfile_date,
			info.f_userinfo_code,
			info.f_idnumber,
			info.f_user_phone,
			ua.f_residential_area,
			sp.f_price_type,
			sp.f_price_name,
			NVL (jt1.F_GAS, 0) gas1,
			NVL (jt2.F_GAS, 0) gas2,
			NVL (jt3.F_GAS, 0) gas3,
			NVL (jt1.F_MONEY, 0) money1,
			NVL (jt2.F_MONEY, 0) money2,
			NVL (jt3.F_MONEY, 0) money3,
			NVL (jt1.F_PRICE, 0) PRICE1,
			NVL (jt2.F_PRICE, 0) PRICE2,
			NVL (jt3.F_PRICE, 0) PRICE3,
			NVL (guding.F_GAS, 0) gdgas,
			NVL (guding.F_PRICE, 0) gdPRICE,
			NVL (guding.F_MONEY, 0) gdMONEY
		FROM
			t_sellinggas s
		LEFT JOIN t_userinfo info ON s.f_userinfo_id = info.f_userinfo_id
		LEFT JOIN t_user_address ua ON info.f_userinfo_id = ua.f_userinfo_id
		LEFT JOIN t_stairprice sp ON s.f_stairprice_id = sp. ID
		LEFT JOIN (
			SELECT
				F_GAS,
				F_MONEY,
				F_PRICE,
				f_charge_id
			FROM
				t_chargeprice
			WHERE
				F_PRICE_NAME = '固定气价'
				and
        {
        startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
        startDate == $$ : $ 1 = 1 $,
        $$
        }
        and
        {
        endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
        endDate == $$ : $ 1 = 1 $,
        $$
        }
		) guding ON s. ID = guding.f_charge_id
		LEFT JOIN (
			SELECT
				F_GAS,
				F_MONEY,
				F_PRICE,
				f_charge_id
			FROM
				t_chargeprice
			WHERE
				F_PRICE_NAME = '阶梯1'
				and
        {
        startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
        startDate == $$ : $ 1 = 1 $,
        $$
        }
        and
        {
        endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
        endDate == $$ : $ 1 = 1 $,
        $$
        }
		) jt1 ON s. ID = jt1.f_charge_id
		LEFT JOIN (
			SELECT
				F_GAS,
				F_MONEY,
				F_PRICE,
				f_charge_id
			FROM
				t_chargeprice
			WHERE
				F_PRICE_NAME = '阶梯2'
				and
        {
        startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
        startDate == $$ : $ 1 = 1 $,
        $$
        }
        and
        {
        endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
        endDate == $$ : $ 1 = 1 $,
        $$
        }
		) jt2 ON s. ID = jt2.f_charge_id
		LEFT JOIN (
			SELECT
				F_GAS,
				F_MONEY,
				F_PRICE,
				f_charge_id
			FROM
				t_chargeprice
			WHERE
				F_PRICE_NAME = '阶梯3'
				and
        {
        startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
        startDate == $$ : $ 1 = 1 $,
        $$
        }
        and
        {
        endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
        endDate == $$ : $ 1 = 1 $,
        $$
        }
		) jt3 ON s. ID = jt3.f_charge_id
	) T
WHERE
	{ condition }
ORDER BY
	f_operate_date DESC
