SELECT
	*
FROM
	(
		SELECT
			u2.f_userinfo_code,
			u2.f_user_name,
			de.f_devices_type,
			u1.f_user_type,
			u1.f_card_id,
			sp.f_price_type,
			sp.f_price_name,
			u1.f_gasproperties,
			u1.f_meternumber,
			u3.f_address,
			u4.f_meter_type,
			u4.f_meter_brand,
			u1.f_user_id,
			u1.f_table_state,
			{ entity.findDialect () == $SqlServer$ : $datediff (
				DAY,
				isnull (
					u5.delivery_date,
					u1.f_input_date
				),
				GETDATE ()
			) $,
			$trunc (SYSDATE) - TRUNC (
				NVL (
					u5.delivery_date,
					u1.f_input_date
				)
			) $ } diffday,
			u5.delivery_date,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (u5.cishu, 0) cishu,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (u5.pregas, 0) pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (u6.sellcishu, 0) sellcishu,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (u6.sellpregas, 0) sellpregas,
			u1.f_filialeids,
			u1.f_filiale
		FROM
			t_userfiles u1
		LEFT JOIN t_userinfo u2 ON u1.f_userinfo_id = u2.f_userinfo_id
		LEFT JOIN t_user_address u3 ON u1.f_useraddress_id = u3. ID
		left join t_devices de   on u1.f_userinfo_id = de.f_userinfo_id
		LEFT JOIN t_gasbrand u4 ON u1.f_gasbrand_id = u4. ID
		left join t_stairprice sp
      on u1.f_price_id = sp.f_price_id
		LEFT JOIN (
			SELECT
				f_user_id,
				COUNT (1) cishu,
				SUM (f_pregas) pregas,
				MAX (f_operate_date) delivery_date
			FROM
				t_sellinggas
			WHERE
				f_state = '有效'
			GROUP BY
				f_user_id
		) u5 ON u1.f_user_id = u5.f_user_id
		LEFT JOIN (
			SELECT
				f_user_id,
				COUNT (1) sellcishu,
				SUM (f_pregas) sellpregas
			FROM
				t_sellinggas
			WHERE
				f_state = '有效'
			AND f_type IN (
				'卡表收费',
				'发卡售气'
			)
			AND f_operate_date BETWEEN { entity.findDialect () == $SqlServer$ : $ {startDate} $,
			$to_date (
				{startDate},
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND { entity.findDialect () == $SqlServer$ : $ {endDate} $,
		$to_date (
			{endDate},
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	GROUP BY
		f_user_id
		) u6 ON u1.f_user_id = u6.f_user_id
	) ss
WHERE
	{ condition }
ORDER BY
	f_user_id