SELECT
	f_operate_date,
	SUM (c) c,
	SUM (f_pregas) f_pregas,
	SUM (f_preamount) f_preamount,
	SUM (f_collection) f_collection
FROM
	(
		--拿收费记录（不拿同一天冲正的记录）
		SELECT
			{ entity.findDialect () == $SqlServer$ : $CONVERT (
				VARCHAR (10),
				f_operate_date,
				120
			) $,
			$TO_CHAR (
				f_operate_date,
				'yyyy-mm-dd'
			) $ } f_operate_date,
			COUNT (ID) c,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_pregas), 0) f_pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_preamount), 0) f_preamount,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_collection), 0) f_collection
		FROM
			t_sellinggas
		WHERE
			f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate} 00:00:00' $,
			$to_date (
				'{startDate} 00:00:00',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate} 23:59:59' $,
		$to_date (
			'{endDate} 23:59:59',
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	AND f_state != '无效'
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
	GROUP BY
		{ entity.findDialect () == $SqlServer$ : $CONVERT (
			VARCHAR (10),
			f_operate_date,
			120
		) $,
		$TO_CHAR (
			f_operate_date,
			'yyyy-mm-dd'
		) $ }
	) s
GROUP BY
	f_operate_date
ORDER BY
	f_operate_date