SELECT
	f_operate_date,
	f_user_type,
	SUM (c) c,
	f_gasproperties,
	SUM (f_pregas) f_pregas
FROM
	(
		--拿收费记录（不拿同一天冲正的记录）
		SELECT
			TO_CHAR (
				f_operate_date,
				'yyyy-mm-dd'
			) f_operate_date,
			f_user_type,
			f_gasproperties,
			COUNT (ID) c,
			NVL (SUM(f_pregas), 0) f_pregas
		FROM
			t_sellinggas
		WHERE
			f_state != '无效'
		AND f_orgstr LIKE '%%'
		AND ID NOT IN (
			SELECT
				f_correct_id
			FROM
				t_correctrecord
		)
		GROUP BY
			TO_CHAR (
				f_operate_date,
				'yyyy-mm-dd'
			),
			f_user_type,
			f_gasproperties
		UNION ALL
			--拿往期冲正金额
			SELECT
				TO_CHAR (
					u1.f_operate_date,
					'yyyy-mm-dd'
				) f_operate_date,
				u2.f_user_type,
				U2.f_gasproperties,
				(0 - COUNT(*)) c,
				NVL (SUM(u1.f_correct_gas), 0) f_pregas
			FROM
				(
					SELECT
						f_correct_id,
						f_operate_date,
						f_correct_gas
					FROM
						t_correctrecord
				) u1
			LEFT JOIN (
				SELECT
					f_user_type,
					f_gasproperties,
					ID
				FROM
					t_sellinggas
				WHERE
					f_state != '无效'
			) u2 ON u1.f_correct_id = u2. ID
			WHERE
				u2. ID IS NOT NULL
			GROUP BY
				TO_CHAR (
					u1.f_operate_date,
					'yyyy-mm-dd'
				),
				f_user_type,
				f_gasproperties
	) s
GROUP BY
	f_operate_date,
	f_user_type,
	f_gasproperties
ORDER BY
	f_operate_date