package com.aote.rs;

import com.af.plugins.DateTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;

@Singleton
@Component
public class NoBuyGas {
    private DateTools dt = new DateTools();

    /**
     * 未购气处理
     */
    //遍历结果集找到不同时间的未购气用户
    public JSONArray dataProcess(JSONArray sqlresult, JSONArray nobuygas, String unit) {
        int unitdate = 0;
        if (unit.equals("month")) {
            unitdate = 30;
        }
        if (unit.equals("day")) {
            unitdate = 1;
        }

        String date[] = new String[nobuygas.length()];
        //时间数组，用以区分不同时间段未购气用户
        for (int i = 0; i < nobuygas.length(); i++) {
            JSONObject jo = (JSONObject) nobuygas.get(i);
            date[i] = String.valueOf((Integer.parseInt(jo.get("date").toString()) * unitdate));
        }
        //循环判断每个用户最后一次是否满足不同时间段的划分
        for (int i = 0; i < sqlresult.length(); i++) {
            for (int j = 0; j < date.length; j++) {
                JSONObject jo = (JSONObject) sqlresult.get(i);
                String datestr = dt.getDiffDate("DATE", "-" + date[j], "yyyy-MM-dd HH:mm:ss");
                if (jo.get("f_operate_date").toString().compareTo(datestr) < 0) {
                    JSONArray ja = new JSONArray();
                    JSONObject jso = (JSONObject) nobuygas.get(j);
                    String s = jso.get("f_userinfo_id").toString();
                    ja = new JSONArray(s);
                    ja.put(jo.get("f_userinfo_id"));
                    jso.put("f_userinfo_id", ja);
                    nobuygas.put(j, jso);
                }
            }
        }
        //去除近期时间段包含过去未购气的用户
        RepeatProcessing(nobuygas);
        //对长期未购气用户进行计数
        CountID(nobuygas);
        return nobuygas;
    }

    //去除近期时间段包含过去未购气的用户
    public void RepeatProcessing(JSONArray data) {
        for (int i = data.length() - 1; i > 0; i--) {
            for (int j = 0; j < i; j++) {
                getDifference((JSONArray) ((JSONObject) data.get(i)).get("f_userinfo_id"), (JSONArray) ((JSONObject) data.get(j)).get("f_userinfo_id"));
            }
        }
    }

    //两个JSONArray进行ja2-ja1的差集操作
    public void getDifference(JSONArray ja1, JSONArray ja2) {
        for (int i = 0; i < ja2.length(); i++) {
            for (int j = 0; j < ja1.length(); j++) {
                if (ja2.get(i).toString().equals(ja1.get(j).toString())) {
                    ja2.remove(i);
                }
            }
        }
    }

    //对长期未购气用户进行计数
    public void CountID(JSONArray data) {
        for (int i = 0; i < data.length(); i++) {
            JSONArray ja = (JSONArray) ((JSONObject) data.get(i)).get("f_userinfo_id");
            ((JSONObject) data.get(i)).put("value", ja.length());
        }
    }
}
