--用户类型 f_user_type,付款方式 f_payment,用气性质 f_gasproperties,收费笔数 c,应交气量 f_pregas,应交金额 f_preamount,实交金额 f_collection
SELECT
	f_payment,
	f_user_type
FROM
	(
		--拿收费记录（不拿同一天冲正的记录）
		SELECT
			f_user_type,
			f_payment,
			f_gasproperties,
			COUNT (ID) c,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_pregas), 0) f_pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_preamount), 0) f_preamount,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_collection), 0) f_collection
		FROM
			t_sellinggas
		WHERE
			f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
			$to_date (
				'{startDate} 00:00:00',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
		$to_date (
			'{endDate} 23:59:59',
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	AND f_state != '无效'
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
	AND ID NOT IN (
		SELECT
			f_correct_id
		FROM
			t_correctrecord
		WHERE
			f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
			$to_date (
				'{startDate} 00:00:00',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
		$to_date (
			'{endDate} 23:59:59',
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
	)
	GROUP BY
		f_user_type,
		f_payment,
		f_gasproperties
	UNION ALL
		--拿往期冲正金额
		SELECT
			u2.f_user_type,
			u2.f_payment,
			u2.f_gasproperties,
			(0 - COUNT(*)) c,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(u1.f_correct_gas), 0) f_pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(u1.f_correct_money), 0) f_preamount,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (
				SUM (u1.f_correct_collection),
				0
			) f_collection
		FROM
			(
				SELECT
					f_correct_id,
					f_correct_gas,
					f_correct_money,
					f_correct_collection
				FROM
					t_correctrecord
				WHERE
					f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
					$to_date (
						'{startDate} 00:00:00',
						'yyyy-mm-dd hh24:mi:ss'
					) $ }
				AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
				$to_date (
					'{endDate} 23:59:59',
					'yyyy-mm-dd hh24:mi:ss'
				) $ }
			AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
			) u1
		LEFT JOIN (
			SELECT
				f_user_type,
				f_payment,
				f_gasproperties,
				ID
			FROM
				t_sellinggas
			WHERE
				f_operate_date < {entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
				$to_date (
					'{startDate} 00:00:00',
					'yyyy-mm-dd hh24:mi:ss'
				) $ }
			AND f_state != '无效'
		) u2 ON u1.f_correct_id = u2. ID
		WHERE
			u2. ID IS NOT NULL
		GROUP BY
			f_user_type,
			f_payment,
			f_gasproperties
	) s
GROUP BY
	f_payment,
	f_user_type