--查询所有购气量和金额
SELECT
	SUM (buka) buka,
	SUM (huanka) huanka,
	SUM (bukaje) bukaje,
	SUM (bksm) bksm
FROM
	(
		SELECT
			COUNT (ID) buka,
			0 huanka,
			0 bukaje,
			0 bksm
		FROM
			t_fillcard
		WHERE
			f_state = '有效'
		AND f_fillcard_type = '补卡'
		AND f_operate_date >= TO_DATE (
		'{startDate} 00:00:00',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f_operate_date <= TO_DATE (
		'{endDate} 23:59:59',
		'yyyy-mm-dd hh24:mi:ss'
	)
		AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
		f_filiale == $$ : $ 1 = 1 $,
		$$ }
	AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
	f_outlets == $$ : $ 1 = 1 $,
	$$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
UNION ALL
	SELECT
		0 buka,
		COUNT (ID) huanka,
		0 bukaje,
			0 bksm
	FROM
		t_fillcard
	WHERE
		f_state = '有效'
	AND f_fillcard_type = '换卡'
	AND f_operate_date >= TO_DATE (
		'{startDate} 00:00:00',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f_operate_date <= TO_DATE (
		'{endDate} 23:59:59',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
 UNION ALL
	SELECT
			0 buka,
		0 huanka,
		sum(f_cardfees) bukaje,
			0 bksm
	FROM
		t_fillcard
	WHERE
		f_state = '有效'
	AND f_fillcard_type = '补卡'
	AND (f_payment != '扫码支付' or f_payment is null)
	AND f_operate_date >= TO_DATE (
		'{startDate} 00:00:00',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f_operate_date <= TO_DATE (
		'{endDate} 23:59:59',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
 UNION ALL
	SELECT
			0 buka,
		0 huanka,
		0 bukaje,
			sum(f_cardfees) bksm
	FROM
		t_fillcard
	WHERE
		f_state = '有效'
	AND f_fillcard_type = '补卡'
	AND f_payment = '扫码支付'
	AND f_operate_date >= TO_DATE (
		'{startDate} 00:00:00',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f_operate_date <= TO_DATE (
		'{endDate} 23:59:59',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
	)