SELECT
	f_user_type,
	f_gasproperties,
	f_devices_type,
	TO_CHAR (
			f_operate_date,
			'yyyy-mm'
		) f_operate_date,
	count (ID) c,
	SUM (f_pregas) f_gas,
	SUM (f_preamount) f_money
FROM
	(
		SELECT
			de.f_devices_type,
			sell.*
		FROM
			(
				SELECT
					*
				FROM
					T_SELLINGGAS
				WHERE
					f_state = '有效'
				AND f_operate_date >= to_date (
					'{startDate} 00:00:00',
					'yyyy-mm-dd hh24:mi:ss'
				) 
			AND f_operate_date <= to_date (
				'{endDate} 23:59:59',
				'yyyy-mm-dd hh24:mi:ss'
			)
		AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
		f_filiale == $$ : $ 1 = 1 $,
		$$ }
	AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
	f_outlets == $$ : $ 1 = 1 $,
	$$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
			) sell
		LEFT JOIN T_DEVICES de ON sell.f_user_id = de.f_user_id
	)
GROUP BY
	f_user_type,
	f_gasproperties,
	f_devices_type,
	TO_CHAR (
			f_operate_date,
			'yyyy-mm'
		)