package com.aote.rs;

import com.aote.sql.AliasTransformer;
import com.aote.sql.SqlServer;
import com.aote.util.ExpressionHelper;
import com.aote.util.SqlHelper;
import org.hibernate.*;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import java.io.*;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Path("sketch")
@Component
@Transactional
public class SketchService {

    @Autowired
    private SessionFactory sessionFactory;

    @GET
    @Path("file/{blobid}/{entity}")
    @Produces(MediaType.APPLICATION_JSON)
    public String getImage(@Context HttpServletResponse response,
                           @PathParam("blobid") String blobid, @PathParam("entity") String entity) {
        try {
            String sql = "select blob from " + entity + " where id = '" + blobid + "'";
            Session session = sessionFactory.getCurrentSession();
            SQLQuery sqlQuery = session.createSQLQuery(sql);

            List list = sqlQuery.list();
            if (list.size() == 0) {
                return "";
            }
            // 获得文件
            Blob file = (Blob) list.get(0);
//            Blob file = (Blob) map.get("blob");
            response.setStatus(HttpServletResponse.SC_OK);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=\""
                    + blobid + "\"");
            OutputStream os = new BufferedOutputStream(response
                    .getOutputStream());
            // 把文件的内容送入响应流中
            InputStream is = file.getBinaryStream();
            transformStream(is, os);
            is.close();
            os.close();


//            SqlHelper.HibernateSQLCall sqlCall = new SqlHelper.HibernateSQLCall(sql, 0, 9999999);
//            sqlCall.transformer = AliasTransformer.INSTANCE;
//            List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
//                    .doInHibernate(session);
//
//
//            // 把文件的内容送入响应流中
//            OutputStream os = new BufferedOutputStream(response
//                    .getOutputStream());
//            if (list.size() == 0) {
//                os.write("".getBytes());
//                os.close();
//                return "";
//            }
//            Map map = (Map) list.get(0);
//            // 获得文件
//            Blob file = (Blob) map.get("blob");
//            // 把文件的内容送入响应流中
//            InputStream is = file.getBinaryStream();
//            transformStream(is, os);
//            is.close();
//            os.close();

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @POST
    @Path("savefile")
    public String savefile(byte[] file,
                           @QueryParam("BlobId") String blob_id,
                           @QueryParam("EntityName") String EntityName) {
        String result = null;
        Map<String, Object> map = new HashMap<String, Object>();
        Session session = sessionFactory.getCurrentSession();
        try {
            map.put("id", blob_id);
            map.put("blob", Hibernate.getLobCreator(session).createBlob(file));
            session.saveOrUpdate(EntityName, map);
            session.flush();
            result = "";
        } catch (Exception e) {
            throw new WebApplicationException(500);
        }
        return result;
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[1024];
            // 读取的实际长度
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
