package com.aote.rs;

import com.aote.sql.AliasTransformer;
import com.aote.util.SqlHelper;
import org.hibernate.Hibernate;
import org.hibernate.LobHelper;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Path("ic/file")
@Component
@Transactional
public class BlobFileService {

    @Autowired
    private SessionFactory sessionFactory;

    @POST
    @Path("savefile")
    public String savefile(byte[] file,
                           @QueryParam("FileName") String filename,
                           @QueryParam("BlobId") String blob_id,
                           @QueryParam("EntityName") String EntityName) {
        String result = null;
        Map<String, Object> map = new HashMap<String, Object>();
        Session session = sessionFactory.getCurrentSession();
        try {
            map.put("filename", filename);
            map.put("id", blob_id);
            map.put("blob", Hibernate.getLobCreator(session).createBlob(file));
            session.saveOrUpdate(EntityName, map);
            session.flush();
            result = "";
        } catch (Exception e) {
            throw new WebApplicationException(500);
        }
        return result;
    }
}
