/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import com.af.plugins.Base64Utils;
import com.af.plugins.CommonTools;
import com.af.plugins.JsonTools;
import com.aote.plugin.MyCommonTools;
import com.aote.plugin.PropertiesUtils;
import com.aote.rs.LogService;
import com.aote.rs.mapper.WebException;
import com.fadada.sdk.base.client.FddBaseClient;
import com.fadada.sdk.base.model.req.AddSignatureParams;
import com.fadada.sdk.base.model.req.BeforeAuthSignParams;
import com.fadada.sdk.base.model.req.ContractFillingParams;
import com.fadada.sdk.base.model.req.ExtSignAutoParams;
import com.fadada.sdk.base.model.req.ExtSignParams;
import com.fadada.sdk.base.model.req.GenerateContractParams;
import com.fadada.sdk.base.model.req.RegisterAccountParams;
import com.fadada.sdk.base.model.req.UploadTemplateParams;
import com.fadada.sdk.extra.client.FddExtraClient;
import com.fadada.sdk.extra.model.req.DefaultSignatureParams;
import com.fadada.sdk.extra.model.req.QuerySignatureParams;
import com.fadada.sdk.extra.model.req.RemoveSignatureParams;
import com.fadada.sdk.extra.model.req.TemplateDeleteParams;
import com.fadada.sdk.extra.model.req.ViewTemplateParams;
import com.fadada.sdk.verify.client.FddVerifyClient;
import com.fadada.sdk.verify.model.req.CancelExtsignAutoPageParams;
import com.fadada.sdk.verify.model.req.CompanyVerifyUrlParams;
import com.fadada.sdk.verify.model.req.PersonVerifyUrlParams;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FddUtils {
    static Logger log = Logger.getLogger(LogService.class);
    @Autowired
    private FddBaseClient baseClient;
    @Autowired
    private FddExtraClient extraClient;
    @Autowired
    private FddVerifyClient verifyClient;

    public void contractFilling(String contractNum) {
        log.info((Object)("\u8fdb\u884c\u5408\u540c\u5f52\u6863\uff0c\u5408\u540c\u7f16\u53f7\uff1a" + contractNum));
        ContractFillingParams params = new ContractFillingParams();
        params.setContractId(contractNum);
        String result = this.baseClient.invokeContractFilling(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("result"))) {
            log.error((Object)("\u5408\u540c\u5f52\u6863\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
    }

    public JSONObject keyExtSignAuto(String transactionId, String contractNum, String customerId, String docTitle, String signKeyword, String keywordStrategy, String keyx, String keyy, String notifyUrl) {
        log.info((Object)"\u8fdb\u5165\u5173\u952e\u5b57\u81ea\u52a8\u7b7e");
        log.info((Object)("\u4ea4\u6613\u53f7\uff1a" + transactionId));
        log.info((Object)("\u5408\u540c\u7f16\u53f7\uff1a" + contractNum));
        log.info((Object)("\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        log.info((Object)("\u6587\u6863\u6807\u9898\uff1a" + docTitle));
        log.info((Object)("\u5173\u952e\u5b57\uff1a" + signKeyword));
        log.info((Object)("\u5173\u952e\u5b57\u7b7e\u7ae0\u7b56\u7565\uff1a" + keywordStrategy));
        log.info((Object)("\u5173\u952e\u5b57\u504f\u79fb\u91cf\uff0cx\uff1a" + keyx + "\uff0cy\uff1a" + keyy));
        log.info((Object)("\u5f02\u6b65\u56de\u8c03\uff1a" + notifyUrl));
        ExtSignAutoParams params = new ExtSignAutoParams();
        params.setTransactionId(transactionId);
        params.setContractId(contractNum);
        params.setCustomerId(customerId);
        params.setDocTitle(docTitle);
        params.setPositionType("0");
        params.setSignKeyword(signKeyword);
        params.setKeywordStrategy(keywordStrategy);
        params.setKeyx(keyx);
        params.setKeyy(keyy);
        params.setNotifyUrl(notifyUrl);
        String result = this.baseClient.invokeExtSignAuto(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("result"))) {
            log.error((Object)("\u83b7\u53d6\u5730\u5740\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json;
    }

    public String keyExtSign(String transactionId, String contractNum, String customerId, String docTitle, String signKeyword, String keywordStrategy, String keyx, String keyy, String readTime, String signType, String returnUrl, String notifyUrl) {
        log.info((Object)"\u8fdb\u5165\u5173\u952e\u5b57\u624b\u52a8\u7b7e");
        log.info((Object)("\u4ea4\u6613\u53f7\uff1a" + transactionId));
        log.info((Object)("\u5408\u540c\u7f16\u53f7\uff1a" + contractNum));
        log.info((Object)("\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        log.info((Object)("\u6587\u6863\u6807\u9898\uff1a" + docTitle));
        log.info((Object)("\u5173\u952e\u5b57\uff1a" + signKeyword));
        log.info((Object)("\u5173\u952e\u5b57\u7b7e\u7ae0\u7b56\u7565\uff1a" + keywordStrategy));
        log.info((Object)("\u5173\u952e\u5b57\u504f\u79fb\u91cf\uff0cx\uff1a" + keyx + "\uff0cy\uff1a" + keyy));
        log.info((Object)("\u5fc5\u8bfb\u65f6\u95f4\uff1a" + readTime));
        log.info((Object)("\u7b7e\u7ae0\u7c7b\u578b\uff1a" + signType));
        log.info((Object)("\u540c\u6b65\u56de\u8c03\uff1a" + returnUrl));
        log.info((Object)("\u5f02\u6b65\u56de\u8c03\uff1a" + notifyUrl));
        ExtSignParams params = new ExtSignParams();
        params.setTransactionId(transactionId);
        params.setContractId(contractNum);
        params.setCustomerId(customerId);
        params.setDocTitle(docTitle);
        params.setPositionType("0");
        params.setSignKeyword(signKeyword);
        params.setKeywordStrategy(keywordStrategy);
        params.setKeyx(keyx);
        params.setKeyy(keyy);
        params.setMobileSignType(signType);
        params.setWritingTrack("1");
        params.setReturnUrl(returnUrl);
        params.setNotifyUrl(notifyUrl);
        params.setReadTime(readTime);
        String result = this.baseClient.invokeExtSign(params);
        log.info((Object)("\u7b7e\u7f72\u5730\u5740\uff1a" + result));
        return result;
    }

    public String cancelAutoSign(String customerId, String returnUrl, String notifyUrl) {
        log.info((Object)"\u83b7\u53d6\u53d6\u6d88\u81ea\u52a8\u7b7e\u6388\u6743\u5730\u5740");
        log.info((Object)("\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        log.info((Object)("\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a" + notifyUrl));
        log.info((Object)("\u540c\u6b65\u901a\u77e5url\uff1a" + returnUrl));
        CancelExtsignAutoPageParams params = new CancelExtsignAutoPageParams();
        params.setCustomerId(customerId);
        params.setNotifyUrl(notifyUrl);
        params.setReturnUrl(returnUrl);
        String result = this.verifyClient.invokeCancelExtsignAutoPage(params);
        log.info((Object)("\u53d6\u6d88\u5730\u5740\uff1a" + result));
        return result;
    }

    public String authAutoSign(String transactionId, String contractNum, String customerId, String returnUrl, String notifyUrl) {
        log.info((Object)"\u83b7\u53d6\u81ea\u52a8\u7b7e\u6388\u6743\u5730\u5740");
        log.info((Object)("\u4ea4\u6613\u53f7\uff1a" + transactionId));
        log.info((Object)("\u5408\u540c\u7f16\u53f7\uff1a" + contractNum));
        log.info((Object)("\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        log.info((Object)("\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a" + notifyUrl));
        log.info((Object)("\u540c\u6b65\u901a\u77e5url\uff1a" + returnUrl));
        BeforeAuthSignParams params = new BeforeAuthSignParams();
        params.setTransactionId(transactionId);
        params.setContractId(contractNum);
        params.setAuthType("1");
        params.setCustomerId(customerId);
        params.setReturnUrl(returnUrl);
        params.setNotifyUrl(notifyUrl);
        String result = this.baseClient.invokeBeforeAuthSign(params);
        log.info((Object)("\u6388\u6743\u5730\u5740\uff1a" + result));
        return result;
    }

    public void defaultSignature(String customerId, String signatureId) {
        log.info((Object)("\u8bbe\u7f6e\u9ed8\u8ba4\u7b7e\u7ae0\uff0c\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId + "\uff0c\u7b7e\u7ae0\u7f16\u53f7\uff1a" + signatureId));
        DefaultSignatureParams params = new DefaultSignatureParams();
        params.setCustomerId(customerId);
        params.setSignatureId(signatureId);
        String result = this.extraClient.invokeDefaultSignature(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u8bbe\u7f6e\u9ed8\u8ba4\u7b7e\u7ae0\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
    }

    public void removeSignature(String customerId, String signatureId) {
        log.info((Object)("\u5220\u9664\u7b7e\u7ae0\uff0c\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId + "\uff0c\u7b7e\u7ae0\u7f16\u53f7\uff1a" + signatureId));
        RemoveSignatureParams params = new RemoveSignatureParams();
        params.setCustomerId(customerId);
        params.setSignatureId(signatureId);
        String result = this.extraClient.invokeRemoveSignature(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u5220\u9664\u7b7e\u7ae0\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
    }

    public JSONObject addSignature(String customerId, String filePath) {
        log.info((Object)("\u6dfb\u52a0\u7b7e\u7ae0\uff0c\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId + "\uff0c\u6587\u4ef6\u8def\u5f84\uff1a" + filePath));
        AddSignatureParams params = new AddSignatureParams();
        params.setCustomerId(customerId);
        params.setFile(new File(filePath));
        String result = this.baseClient.invokeAddSignature(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u6dfb\u52a0\u7b7e\u7ae0\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json.getJSONObject("data");
    }

    public JSONArray querySignature(String customerId) {
        log.info((Object)("\u83b7\u53d6\u7b7e\u7ae0\uff0c\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        QuerySignatureParams params = new QuerySignatureParams();
        params.setCustomerId(customerId);
        String result = this.extraClient.invokeQuerySignature(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u83b7\u53d6\u7b7e\u7ae0\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json.getJSONArray("data");
    }

    public JSONObject companyVerifyUrl(String customerId, String notifyUrl, String returnUrl) {
        log.info((Object)"\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740");
        log.info((Object)("\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        log.info((Object)("\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a" + notifyUrl));
        log.info((Object)("\u540c\u6b65\u901a\u77e5url\uff1a" + returnUrl));
        CompanyVerifyUrlParams params = new CompanyVerifyUrlParams();
        params.setCustomerId(customerId);
        params.setPageModify("1");
        params.setNotifyUrl(notifyUrl);
        params.setReturnUrl(returnUrl);
        params.setCertFlag("1");
        String result = this.verifyClient.invokeCompanyVerifyUrl(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u83b7\u53d6\u5730\u5740\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json.getJSONObject("data");
    }

    public JSONObject personVerifyUrl(String customerId, String notifyUrl, String returnUrl) {
        log.info((Object)"\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740");
        log.info((Object)("\u5ba2\u6237\u7f16\u53f7\uff1a" + customerId));
        log.info((Object)("\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a" + notifyUrl));
        log.info((Object)("\u540c\u6b65\u901a\u77e5url\uff1a" + returnUrl));
        PersonVerifyUrlParams params = new PersonVerifyUrlParams();
        params.setCustomerId(customerId);
        params.setVerifiedWay("0");
        params.setPageModify("1");
        params.setNotifyUrl(notifyUrl);
        params.setReturnUrl(returnUrl);
        params.setCertFlag("1");
        String result = this.verifyClient.invokePersonVerifyUrl(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u83b7\u53d6\u5730\u5740\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json.getJSONObject("data");
    }

    public String register(String type, String openID) {
        log.info((Object)"\u8fdb\u5165\u6ce8\u518c\u8d26\u53f7");
        log.info((Object)("\u8d26\u53f7\u7c7b\u578b\uff1a" + type));
        log.info((Object)("\u552f\u4e00\u6807\u8bc6\uff1a" + openID));
        switch (type) {
            case "\u4e2a\u4eba": {
                type = "1";
                break;
            }
            case "\u4f01\u4e1a": {
                type = "2";
                break;
            }
            default: {
                throw new WebException(500, "\u672a\u77e5\u7528\u6237\u7c7b\u578b");
            }
        }
        RegisterAccountParams params = new RegisterAccountParams();
        params.setAccountType(type);
        params.setOpenId(openID);
        String result = this.baseClient.invokeRegisterAccount(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u6ce8\u518c\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json.getString("data");
    }

    public JSONObject generateContract(String docTitle, String contractNum, String templateId, String parameterMap) {
        log.info((Object)"\u5f00\u59cb\u751f\u6210\u5408\u540c\uff01\uff01\uff01");
        log.info((Object)("\u5408\u540c\u6807\u9898\uff1a" + docTitle));
        log.info((Object)("\u5408\u540c\u7f16\u53f7\uff1a" + contractNum));
        log.info((Object)("\u6a21\u677f\u7f16\u53f7\uff1a" + templateId));
        log.info((Object)("\u8868\u5355\u5185\u5bb9\uff1a" + parameterMap));
        GenerateContractParams params = new GenerateContractParams();
        params.setDocTitle(docTitle);
        params.setContractId(contractNum);
        params.setTemplateId(templateId);
        params.setParameterMap(parameterMap);
        String result = this.baseClient.invokeGenerateContract(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("result"))) {
            log.error((Object)("\u5408\u540c\u751f\u6210\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
        return json;
    }

    public void deleteTemplate(String templateId) {
        log.info((Object)("\u5220\u9664\u6a21\u677f\uff0c\u6a21\u677f\u7f16\u53f7\uff1a" + templateId));
        TemplateDeleteParams params = new TemplateDeleteParams();
        params.setTemplateId(templateId);
        String result = this.extraClient.invokeTemplateDelete(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("msg"))) {
            log.error((Object)("\u6a21\u677f\u4e0a\u4f20\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
    }

    public String lookTemplate(String templateId) {
        log.info((Object)("\u83b7\u53d6\u6a21\u677f\u5728\u7ebf\u5730\u5740\uff0c\u6a21\u677f\u7f16\u53f7\uff1a" + templateId));
        ViewTemplateParams params = new ViewTemplateParams();
        params.setTemplateId(templateId);
        String result = this.extraClient.invokeViewTemplate(params);
        return result;
    }

    public void uploadTemplate(String templateId, String filePath) {
        log.info((Object)"\u5408\u540c\u6a21\u677f\u5f00\u59cb\u4e0a\u4f20");
        log.info((Object)("\u6a21\u677f\u7f16\u53f7\uff1a" + templateId));
        log.info((Object)("\u6a21\u677f\u5730\u5740\uff1a" + filePath));
        UploadTemplateParams params = new UploadTemplateParams();
        params.setTemplateId(templateId);
        params.setFile(new File(filePath));
        String result = this.baseClient.invokeUploadTemplate(params);
        log.info((Object)("\u8fd4\u56de\u5185\u5bb9\uff1a" + result));
        JSONObject json = JsonTools.convertToJson((String)result);
        if (!"success".equals(json.getString("result"))) {
            log.error((Object)("\u6a21\u677f\u4e0a\u4f20\u5931\u8d25\uff1a" + json.getString("msg")));
            throw new WebException(500, json.getString("msg"));
        }
    }

    public boolean checkAuthSign(JSONObject data) throws IOException {
        String sign;
        String ciphertext = PropertiesUtils.getKeyValue("fdd.app_secret") + data.getString("authenticationType") + data.getString("certStatus") + data.getString("customerId") + data.getString("serialNo") + data.getString("status") + data.getString("statusDesc");
        ciphertext = MyCommonTools.sha1Hex(ciphertext).toUpperCase();
        ciphertext = PropertiesUtils.getKeyValue("fdd.app_id") + CommonTools.md5((String)data.getString("timestamp")).toUpperCase() + ciphertext;
        ciphertext = MyCommonTools.sha1Hex(ciphertext).toUpperCase();
        return (ciphertext = Base64Utils.encode((byte[])ciphertext.getBytes())).equals(sign = data.getString("sign"));
    }

    public boolean checkSignDigest(JSONObject data) throws IOException {
        String msg_digest;
        String ciphertext = PropertiesUtils.getKeyValue("fdd.app_secret") + data.getString("transaction_id");
        ciphertext = MyCommonTools.sha1Hex(ciphertext).toUpperCase();
        ciphertext = PropertiesUtils.getKeyValue("fdd.app_id") + CommonTools.md5((String)data.getString("timestamp")).toUpperCase() + ciphertext;
        ciphertext = MyCommonTools.sha1Hex(ciphertext).toUpperCase();
        return (ciphertext = Base64Utils.encode((byte[])ciphertext.getBytes())).equals(msg_digest = data.getString("msg_digest"));
    }

    public boolean checkCancelAutoDigest(JSONObject data) throws IOException {
        String msg_digest;
        String ciphertext = PropertiesUtils.getKeyValue("fdd.app_secret") + data.getString("customer_id") + data.getString("remark") + data.getString("status") + data.getString("update_time");
        ciphertext = MyCommonTools.sha1Hex(ciphertext).toUpperCase();
        ciphertext = PropertiesUtils.getKeyValue("fdd.app_id") + CommonTools.md5((String)data.getString("timestamp")).toUpperCase() + ciphertext;
        ciphertext = MyCommonTools.sha1Hex(ciphertext).toUpperCase();
        return (ciphertext = Base64Utils.encode((byte[])ciphertext.getBytes())).equals(msg_digest = data.getString("msg_digest"));
    }
}

