package com.af.expression;

import com.af.expression.exception.ReturnWayException;

import java.util.HashMap;
import java.util.Map;

/**
 * 执行单元，保存所有虚参，Expression编译后的结果
 *
 * @author 何宁社
 */
public class Delegate {
	/**
	 * 参数值及变量值存放处
	 */
	private Map<String, Object> objectNames = new HashMap<>();

	// json对象是否支持可选，支持可选，将去掉属性值计算错误的属性
	public boolean CanJsonPropertyChoise = false;

	/**
	 * 执行时的Expression
	 */
	private final Expression exp;

	/**
	 * 用Expression构造，执行时最顶层Expression
	 * @param exp 表达式
	 */
	public Delegate(Expression exp) {
		this.exp = exp;
	}

	/**
	 * 无参执行过程
	 * @return 结果
	 */
	public Object invoke() {
		return this.invoke(new HashMap<>(8));
	}

	/**
	 * 执行程序，执行前，参数必须实例化
	 * @param params 执行时，所带参数值
	 * @return 执行结果
	 */
	public Object invoke(Map<String, Object> params) {
		// 把初始参数给参数表
		setObjectNames(params);
		// 沿根Expression节点遍历，把delegate传递下去
		putDelegate(this.exp);
		// 调用exp的执行过程
		try {
			return exp.invoke();
		} catch (ReturnWayException returnWay) {
			return returnWay.getReturnObject();
		}
	}

	/**
	 * 沿根节点递归，传递delegate的过程
	 * @param parent 表达式
	 */
	private void putDelegate(Expression parent) {
		for (Expression child : parent.children) {
			// 有些节点会放空的子节点
			if (child == null) {
				continue;
			}
			child.setDelegate(this);
			putDelegate(child);
		}
	}

	public Expression getExp() {
		return this.exp;
	}

	public void setObjectNames(Map<String, Object> objectNames){
		this.objectNames = objectNames;
	}

	public void put(String key, Object value){
		objectNames.put(key, value);
	}

	public Object get(String key){
		return objectNames.get(key);
	}

	public boolean containsKey(String key){
		return objectNames.containsKey(key);
	}
}
