package com.aote.xingtai;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.json.JSONArray;
import org.json.JSONString;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DataSynchronism {
	// 执行业务的logicName
	private String logicName;
	private String logicPath;
	public String getlogicPath() {
		return logicPath;
	}
	public String getLogicName() {
		return logicName;
	}
	public void setlogicPath(String logicPath) {
		this.logicPath = logicPath;
	}
	public void setLogicName(String logicName) {
		this.logicName = logicName;
	}

	// 请求路径
	private String httpurl;
	public String getHttpurl() {
		return httpurl;
	}

	public void setHttpurl(String httpurl) {
		this.httpurl = httpurl;
	}

	public void getDataSync() throws Exception{
		System.out.println("档案同步定是开始");
		String result = "";
//		String result = "{'Error':{'RetCode':'00','ErrMsg':'正常'},'Data':[{'Building':'','Operator':'销售公司收费员','Meterdirection':'左','Address':'钢铁路南','MeterType':'机表','OpenDate':'20050801','GongFu_MeterType':'机械表','CompanyName':'销售公司','MeterTitles':'','GasUserId':'1010200100020','Phone':'13082019607$@--$@--','UserNature':'工福','MeterName':'机表流量计','MeterNum':'','UserName':'钢南快餐','CompanyId':'14','LastChargeDate':'2020-04-16 09:06:00','UnitNum':'','TownName':'机表','MeterModel':'G40','Area':'邢台市区','HouseNum':'','Price':'天然气机表经营3.46-3.77','IdNum':'','AreaCode':'100','GasTypeName':'普通用户','UserType':'经营','GongFu_IsICMeter':'否'}]}}";
		//1.先请求档案更新接口，获取改变的用户信息
		result = getUserData();
		// 将结果存到本地文件中，防止后续看问题
		WriteNewLog(result);
		// 返回结果进行转换;
		JSONObject resjson = new JSONObject(result);
		JSONObject rescode = resjson.getJSONObject("Error");
		String code = rescode.getString("RetCode");
        System.out.println(code);
		//2.根据返回值，判断是否执行档案同步logic
		if (!code.equals("00")){
			throw new RuntimeException("档案同步异常：" + code);
		}else{
			JSONArray arrJson= resjson.getJSONArray("Data");
            System.out.println(arrJson.length());
			if(arrJson.length()> 0){
				for(int i = 0;i<arrJson.length();i++){
					try{
						// 转成和logic同样格式的数据； 方便批量数据直接请求logic不走插件
						JSONObject oneData= arrJson.getJSONObject(i);
						JSONObject dodata= new JSONObject();
						dodata.append("Data",oneData);
						runlogic(dodata);
					}catch (Exception e){
						System.out.println("该条同步数据出错");
					}
				}
			}
		}
	}

	/*
	获取需要更新的档案信息
	 */
	private String getUserData()throws Exception{
		// POSTMethod
		HttpPost postMethod =new HttpPost(httpurl);
		StringEntity se = new StringEntity("{}", "UTF-8");
		postMethod.setEntity(se);
		// 发送Post请求
		HttpClient httpClient = new DefaultHttpClient();
		HttpResponse response = httpClient.execute(postMethod);
		int code = response.getStatusLine().getStatusCode();
		// 如果不成功
		if (code != 200) {
			throw new RuntimeException("同步档案请求失败：" + code);
		} else
			System.out.println("返回值先不进行编码格式转换");
			System.out.println(response.getEntity());
			return EntityUtils.toString(response.getEntity(), "GBK");
	}
	// 执行logic业务逻辑
	private String runlogic(JSONObject params) throws Exception {
		String path= "" + logicPath+ logicName;
		String body = "{\"data\":" + params + "}";
		// POSTMethod
		HttpPost postMethod =new HttpPost(path);
		StringEntity se = new StringEntity(body, "UTF-8");
		postMethod.setEntity(se);
		// 发送Post请求
		HttpClient httpClient = new DefaultHttpClient();
		HttpResponse response = httpClient.execute(postMethod);
		int code = response.getStatusLine().getStatusCode();
		// 如果不成功
		if (code != 200) {
			throw new RuntimeException("业务逻辑logic：" + logicName + "-返回值错误：" + code);
		} else
			return "200";
	}
	/*
	把每天取到得用户档案信息，存起来
	 */
	public void WriteNewLog(String jsonlog){
		try {
			//文件名
			String fileName = new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".txt";
			//文件路径
			String filePath = "D:\\updateUserlog\\";
			File newlog = new File(filePath +fileName);
			if(!newlog.isFile()){
				newlog.createNewFile();
			}
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(newlog),"utf-8"));
			bw.write(jsonlog);
			bw.close();
		}catch (Exception e) {
			System.out.println("存储文件失败");
			e.printStackTrace();
		}
	}
}
