/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.icbc;

import cn.com.infosec.icbc.DNItemReverseUtil;
import cn.com.infosec.icbccrypto.CEA;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.util.base64.MyBASE64Decoder;
import cn.com.infosec.util.base64.MyBASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class ReturnValue {
    static {
        Security.addProvider((Provider)new InfosecProvider());
    }

    public static byte[] base64enc(byte[] src) {
        byte[] result = null;
        try {
            MyBASE64Encoder base64 = new MyBASE64Encoder();
            result = base64.encode(src).getBytes();
        }
        catch (Exception x) {
            x.printStackTrace();
            result = null;
        }
        return result;
    }

    public static byte[] base64dec(byte[] src) {
        byte[] result = null;
        try {
            try {
                MyBASE64Decoder base64 = new MyBASE64Decoder();
                ByteArrayInputStream is = new ByteArrayInputStream(src);
                result = base64.decodeBuffer((InputStream)is);
            }
            catch (Exception x) {
                x.printStackTrace();
                result = null;
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    public static byte[] desEncrypt(byte[] src, byte[] key) throws InvalidKeySpecException, IOException, NoSuchProviderException, NoSuchAlgorithmException {
        byte[] result = null;
        try {
            byte[] iv = new byte[8];
            int i = 0;
            while (i < 8) {
                iv[i] = (byte)(i + 1);
                ++i;
            }
            IvParameterSpec spec = new IvParameterSpec(iv);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESEDE", "INFOSEC");
            DESedeKeySpec keySpec = new DESedeKeySpec(key);
            SecretKey sKey = keyFactory.generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance("DESEDE", "INFOSEC");
            cipher.init(1, (Key)sKey, spec);
            result = cipher.doFinal(src);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = null;
        }
        return result;
    }

    public static byte[] desDecrypt(byte[] src, byte[] Key2) throws InvalidKeySpecException, IOException, NoSuchProviderException, NoSuchAlgorithmException {
        byte[] result = null;
        try {
            byte[] iv = new byte[8];
            int i = 0;
            while (i < 8) {
                iv[i] = (byte)(i + 1);
                ++i;
            }
            IvParameterSpec spec = new IvParameterSpec(iv);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESEDE", "INFOSEC");
            DESedeKeySpec keySpec = new DESedeKeySpec(Key2);
            SecretKey key = keyFactory.generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance("DESEDE", "INFOSEC");
            cipher.init(2, (Key)key, spec);
            result = cipher.doFinal(src);
            if (result.length > src.length) {
                byte[] newResult = new byte[src.length];
                System.arraycopy(result, 0, newResult, 0, src.length);
                result = new byte[newResult.length];
                System.arraycopy(newResult, 0, result, 0, newResult.length);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = null;
        }
        return result;
    }

    public static byte[] genDESKey(byte[] seed, int length) throws NoSuchAlgorithmException {
        byte[] result = null;
        try {
            SecureRandom random = new SecureRandom();
            random.setSeed(seed);
            result = random.generateSeed(length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = null;
        }
        return result;
    }

    public static String getCertID(byte[] cert) {
        String result = null;
        try {
            if (cert[0] != 48 || cert[1] != -126) {
                int certLen = cert.length;
                byte[] cert1 = new byte[certLen];
                int temp = 0;
                int len = 0;
                int cutLen = 0;
                int tempLen = 0;
                while (len < certLen) {
                    temp = cert[len];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen = temp << 16;
                    temp = cert[len + 1];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen += temp << 8;
                    temp = cert[len + 2];
                    if (temp < 0) {
                        temp += 256;
                    }
                    System.arraycopy(cert, len + 3, cert1, len - cutLen, tempLen += temp);
                    len += tempLen + 3;
                    cutLen += 3;
                }
                cert = new byte[certLen - cutLen];
                System.arraycopy(cert1, 0, cert, 0, certLen -= cutLen);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            ByteArrayInputStream bin = new ByteArrayInputStream(cert);
            Certificate certificate = cf.generateCertificate(bin);
            bin.close();
            result = ((X509Certificate)certificate).getSubjectDN().getName();
            if (DNItemReverseUtil.isDNReversed(result)) {
                result = DNItemReverseUtil.reverseDN(result);
            }
            StringTokenizer st1 = null;
            StringTokenizer st = new StringTokenizer(result, ",");
            String ret = null;
            String temp = null;
            String temp1 = null;
            while (st.hasMoreTokens()) {
                temp = st.nextToken();
                st1 = new StringTokenizer(temp, "=");
                temp1 = st1.nextToken();
                temp1 = st1.nextToken();
                temp1 = String.valueOf(temp1) + "\n";
                ret = ret == null ? temp1 : String.valueOf(ret) + temp1;
            }
            result = ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = null;
        }
        return result;
    }

    public static boolean checkCertLength(byte[] cert) {
        if (cert[0] != 48 || cert[1] != -126) {
            return false;
        }
        int certLen = cert.length;
        if (certLen < 256) {
            return false;
        }
        int temp = 0;
        int tempLen = 0;
        temp = cert[2];
        if (temp < 0) {
            temp += 256;
        }
        tempLen = temp * 16 * 16;
        temp = cert[3];
        if (temp < 0) {
            temp += 256;
        }
        return (tempLen += temp + 4) == certLen;
    }

    public static byte[][] genRSAKey(int inKeyLenInBit, byte[] seed) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        byte[][] retValue = new byte[2][];
        try {
            try {
                SecureRandom random = new SecureRandom();
                random.setSeed(seed);
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "INFOSEC");
                keyPairGenerator.initialize(inKeyLenInBit);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                retValue[0] = keyPair.getPrivate().getEncoded();
                retValue[1] = keyPair.getPublic().getEncoded();
            }
            catch (Exception x) {
                x.printStackTrace();
                retValue[1] = null;
                retValue[0] = null;
            }
        }
        catch (Throwable throwable) {}
        return retValue;
    }

    public static byte[] getPublicKey(byte[] cert) throws CertificateException, IOException, NoSuchProviderException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] result = null;
        try {
            if (cert[0] != 48 || cert[1] != -126) {
                int certLen = cert.length;
                byte[] cert1 = new byte[certLen];
                int temp = 0;
                int len = 0;
                int cutLen = 0;
                int tempLen = 0;
                while (len < certLen) {
                    temp = cert[len];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen = temp << 16;
                    temp = cert[len + 1];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen += temp << 8;
                    temp = cert[len + 2];
                    if (temp < 0) {
                        temp += 256;
                    }
                    System.arraycopy(cert, len + 3, cert1, len - cutLen, tempLen += temp);
                    len += tempLen + 3;
                    cutLen += 3;
                }
                cert = new byte[certLen - cutLen];
                System.arraycopy(cert1, 0, cert, 0, certLen -= cutLen);
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert);
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "INFOSEC");
            Certificate certificate = factory.generateCertificate(bIn);
            bIn.close();
            PublicKey pubKey = certificate.getPublicKey();
            result = pubKey.getEncoded();
            if (result == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            result = null;
        }
        return result;
    }

    public static byte[] getPrivateKey(byte[] bPrivateKey, char[] password) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidKeySpecException {
        byte[] priKey = null;
        try {
            byte[] temp = new byte[bPrivateKey.length - 2];
            System.arraycopy(bPrivateKey, 2, temp, 0, temp.length);
            priKey = new byte[temp.length];
            CEA cea = new CEA();
            byte[] pass = new String(password).getBytes();
            int rv = cea.Decrypt(temp, priKey, temp.length, pass, pass.length);
            if (rv != 0) {
                return null;
            }
            return priKey;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte[] sign(byte[] src, int srcLen, byte[] privateKey, char[] keyPass) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        byte[] signedResult = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1", "INFOSEC");
            byte[] hash = md.digest(src);
            signedResult = ReturnValue.privateEncryptPwd(hash, privateKey, keyPass);
        }
        catch (Exception x) {
            x.printStackTrace();
            signedResult = null;
        }
        return signedResult;
    }

    public static int verifySign(byte[] src, int srcLen, byte[] cert, byte[] sign) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        boolean rv = false;
        rv = ReturnValue.checkCertLength(cert);
        if (!rv) {
            return -1;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1", "INFOSEC");
            byte[] hash = md.digest(src);
            byte[] restoredHash = ReturnValue.publicDecryptCert(sign, cert);
            if (Arrays.equals(restoredHash, hash)) {
                return 0;
            }
            return 1;
        }
        catch (Exception x) {
            x.printStackTrace();
            rv = false;
            return 1;
        }
    }

    public static byte[] privateEncryptPwd(byte[] src, byte[] privateKey, char[] keyPass) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidKeySpecException {
        byte[] result = null;
        try {
            byte[] temp = new byte[privateKey.length - 2];
            System.arraycopy(privateKey, 2, temp, 0, temp.length);
            CEA cea = new CEA();
            byte[] pass = new String(keyPass).getBytes();
            byte[] priKey = new byte[temp.length];
            int rv = cea.Decrypt(temp, priKey, temp.length, pass, pass.length);
            if (rv != 0) {
                return null;
            }
            result = ReturnValue.privateEncrypt(src, priKey);
            return result;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public static byte[] privateDecryptPwd(byte[] src, byte[] privateKey, char[] keyPass) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidKeySpecException {
        byte[] result;
        block5: {
            result = null;
            try {
                try {
                    byte[] temp = new byte[privateKey.length - 2];
                    System.arraycopy(privateKey, 2, temp, 0, temp.length);
                    CEA cea = new CEA();
                    byte[] pass = new String(keyPass).getBytes();
                    byte[] priKey = new byte[temp.length];
                    int rv = cea.Decrypt(temp, priKey, temp.length, pass, pass.length);
                    if (rv != 0) {
                        result = null;
                        break block5;
                    }
                    result = ReturnValue.privateDecrypt(src, priKey);
                }
                catch (Exception x) {
                    x.printStackTrace();
                    result = null;
                }
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static byte[] privateEncrypt(byte[] src, byte[] privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidKeySpecException {
        byte[] result = null;
        try {
            try {
                PKCS8EncodedKeySpec prikeySpec = new PKCS8EncodedKeySpec(privateKey);
                KeyFactory kf = KeyFactory.getInstance("RSA", "INFOSEC");
                PrivateKey pkey = kf.generatePrivate(prikeySpec);
                Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
                rsaCipher.init(1, pkey);
                int blockSize = rsaCipher.getBlockSize();
                int inLen = src.length;
                result = new byte[(inLen + blockSize - 1) / blockSize * (blockSize + 11)];
                byte[] temp = null;
                int outOffset = 0;
                int inOffset = 0;
                while (inLen > blockSize) {
                    rsaCipher.init(1, pkey);
                    temp = rsaCipher.doFinal(src, inOffset, blockSize);
                    System.arraycopy(temp, 0, result, outOffset, temp.length);
                    inOffset += blockSize;
                    inLen -= blockSize;
                    outOffset += temp.length;
                }
                rsaCipher.init(1, pkey);
                temp = rsaCipher.doFinal(src, inOffset, inLen);
                System.arraycopy(temp, 0, result, outOffset, temp.length);
            }
            catch (Exception x) {
                x.printStackTrace();
                result = null;
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    public static byte[] privateDecrypt(byte[] src, byte[] privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidKeySpecException {
        byte[] result1 = null;
        try {
            try {
                PKCS8EncodedKeySpec prikeySpec = new PKCS8EncodedKeySpec(privateKey);
                KeyFactory kf = KeyFactory.getInstance("RSA", "INFOSEC");
                PrivateKey pkey = kf.generatePrivate(prikeySpec);
                Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
                rsaCipher.init(2, pkey);
                int blockSize = rsaCipher.getBlockSize();
                int inLen = src.length;
                byte[] result = new byte[(inLen + blockSize - 1) / blockSize * (blockSize - 11)];
                byte[] temp = null;
                int outOffset = 0;
                int inOffset = 0;
                while (inLen > blockSize) {
                    rsaCipher.init(2, pkey);
                    temp = rsaCipher.doFinal(src, inOffset, blockSize);
                    System.arraycopy(temp, 0, result, outOffset, temp.length);
                    inOffset += blockSize;
                    inLen -= blockSize;
                    outOffset += temp.length;
                }
                rsaCipher.init(2, pkey);
                temp = rsaCipher.doFinal(src, inOffset, inLen);
                System.arraycopy(temp, 0, result, outOffset, temp.length);
                result1 = new byte[outOffset + temp.length];
                System.arraycopy(result, 0, result1, 0, outOffset + temp.length);
            }
            catch (Exception x) {
                x.printStackTrace();
                result1 = null;
            }
        }
        catch (Throwable throwable) {}
        return result1;
    }

    public static byte[] publicEncryptCert(byte[] src, byte[] cert) throws CertificateException, IOException, NoSuchProviderException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] result = null;
        try {
            if (cert[0] != 48 || cert[1] != -126) {
                int certLen = cert.length;
                byte[] cert1 = new byte[certLen];
                int temp = 0;
                int len = 0;
                int cutLen = 0;
                int tempLen = 0;
                while (len < certLen) {
                    temp = cert[len];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen = temp << 16;
                    temp = cert[len + 1];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen += temp << 8;
                    temp = cert[len + 2];
                    if (temp < 0) {
                        temp += 256;
                    }
                    System.arraycopy(cert, len + 3, cert1, len - cutLen, tempLen += temp);
                    len += tempLen + 3;
                    cutLen += 3;
                }
                cert = new byte[certLen - cutLen];
                System.arraycopy(cert1, 0, cert, 0, certLen -= cutLen);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            ByteArrayInputStream bin = new ByteArrayInputStream(cert);
            Certificate certificate = cf.generateCertificate(bin);
            bin.close();
            PublicKey pubKey = certificate.getPublicKey();
            byte[] tempPubKey = pubKey.getEncoded();
            result = ReturnValue.publicEncrypt(src, tempPubKey);
        }
        catch (Exception x) {
            x.printStackTrace();
            result = null;
        }
        return result;
    }

    public static byte[] publicDecryptCert(byte[] src, byte[] cert) throws CertificateException, IOException, NoSuchProviderException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] result = null;
        try {
            if (cert[0] != 48 || cert[1] != -126) {
                int certLen = cert.length;
                byte[] cert1 = new byte[certLen];
                int temp = 0;
                int len = 0;
                int cutLen = 0;
                int tempLen = 0;
                while (len < certLen) {
                    temp = cert[len];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen = temp << 16;
                    temp = cert[len + 1];
                    if (temp < 0) {
                        temp += 256;
                    }
                    tempLen += temp << 8;
                    temp = cert[len + 2];
                    if (temp < 0) {
                        temp += 256;
                    }
                    System.arraycopy(cert, len + 3, cert1, len - cutLen, tempLen += temp);
                    len += tempLen + 3;
                    cutLen += 3;
                }
                cert = new byte[certLen - cutLen];
                System.arraycopy(cert1, 0, cert, 0, certLen -= cutLen);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            ByteArrayInputStream bin = new ByteArrayInputStream(cert);
            Certificate certificate = cf.generateCertificate(bin);
            bin.close();
            PublicKey pubKey = certificate.getPublicKey();
            byte[] tempPubKey = pubKey.getEncoded();
            result = ReturnValue.publicDecrypt(src, tempPubKey);
        }
        catch (Exception x) {
            x.printStackTrace();
            result = null;
        }
        return result;
    }

    public static byte[] publicEncrypt(byte[] src, byte[] publicKey) throws IOException, NoSuchProviderException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] result = null;
        try {
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "INFOSEC");
                PublicKey pubKey = keyFactory.generatePublic(keySpec);
                Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
                rsaCipher.init(1, pubKey);
                int blockSize = rsaCipher.getBlockSize();
                int inLen = src.length;
                result = new byte[(inLen + blockSize - 1) / blockSize * (blockSize + 11)];
                byte[] temp = null;
                int outOffset = 0;
                int inOffset = 0;
                while (inLen > blockSize) {
                    rsaCipher.init(1, pubKey);
                    temp = rsaCipher.doFinal(src, inOffset, blockSize);
                    System.arraycopy(temp, 0, result, outOffset, temp.length);
                    inOffset += blockSize;
                    inLen -= blockSize;
                    outOffset += temp.length;
                }
                rsaCipher.init(1, pubKey);
                temp = rsaCipher.doFinal(src, inOffset, inLen);
                System.arraycopy(temp, 0, result, outOffset, temp.length);
            }
            catch (Exception x) {
                x.printStackTrace();
                result = null;
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    public static byte[] publicDecrypt(byte[] src, byte[] publicKey) throws IOException, NoSuchProviderException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] result1 = null;
        try {
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "INFOSEC");
                PublicKey pubKey = keyFactory.generatePublic(keySpec);
                Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
                rsaCipher.init(2, pubKey);
                int blockSize = rsaCipher.getBlockSize();
                int inLen = src.length;
                byte[] result = new byte[(inLen + blockSize - 1) / blockSize * (blockSize - 11)];
                byte[] temp = null;
                int outOffset = 0;
                int inOffset = 0;
                while (inLen > blockSize) {
                    rsaCipher.init(2, pubKey);
                    temp = rsaCipher.doFinal(src, inOffset, blockSize);
                    System.arraycopy(temp, 0, result, outOffset, temp.length);
                    inOffset += blockSize;
                    inLen -= blockSize;
                    outOffset += temp.length;
                }
                rsaCipher.init(2, pubKey);
                temp = rsaCipher.doFinal(src, inOffset, inLen);
                System.arraycopy(temp, 0, result, outOffset, temp.length);
                result1 = new byte[outOffset + temp.length];
                System.arraycopy(result, 0, result1, 0, outOffset + temp.length);
            }
            catch (Exception x) {
                x.printStackTrace();
                result1 = null;
            }
        }
        catch (Throwable throwable) {}
        return result1;
    }
}

