/*
 * Decompiled with CFR 0.152.
 */
import cn.com.infosec.icbc.ReturnValue;
import cn.com.infosec.jce.provider.InfosecProvider;
import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;

public class Test {
    public static void main(String[] args) {
        ReturnValue test = new ReturnValue();
        Security.addProvider((Provider)new InfosecProvider());
        byte[] plaintext = "this is a test message to be test in cn.com.infosec.icbc".getBytes();
        byte[] ciphertext = null;
        byte[] restoredPlaintext = null;
        try {
            System.out.print("test ReturnValue.base64enc() and ReturnValue.base64dec()...");
            byte[] encodedMsg = ReturnValue.base64enc(plaintext);
            byte[] decodedMsg = ReturnValue.base64dec(encodedMsg);
            if (Arrays.equals(decodedMsg, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.genDESKey()...");
            byte[] seed = new byte[]{1, 2, 3, 4};
            byte[] desKey = ReturnValue.genDESKey(seed, 24);
            System.out.println("OK");
            System.out.print("test ReturnValue.desEncrypt() and ReturnValue.desDecrypt() ...");
            ciphertext = ReturnValue.desEncrypt(plaintext, desKey);
            restoredPlaintext = ReturnValue.desDecrypt(ciphertext, desKey);
            if (Arrays.equals(restoredPlaintext, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.genRSAKey() ...");
            byte[][] key = ReturnValue.genRSAKey(1024, seed);
            if (key[0] != null && key[1] != null) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.publicEncrypt() and ReturnValue.privateDecrypt()...");
            ciphertext = ReturnValue.privateEncrypt(plaintext, key[0]);
            restoredPlaintext = ReturnValue.publicDecrypt(ciphertext, key[1]);
            if (Arrays.equals(restoredPlaintext, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.privateEncrypt() and ReturnValue.publicDecrypt()...");
            ciphertext = ReturnValue.publicEncrypt(plaintext, key[1]);
            restoredPlaintext = ReturnValue.privateDecrypt(ciphertext, key[0]);
            if (Arrays.equals(restoredPlaintext, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            FileInputStream fis = new FileInputStream("99billtest.key");
            byte[] privateKey = new byte[fis.available()];
            fis.read(privateKey);
            fis.close();
            fis = new FileInputStream("99billtest.cer");
            byte[] cert = new byte[fis.available()];
            fis.read(cert);
            fis.close();
            System.out.print("test ReturnValue.getCertID()...");
            String id = ReturnValue.getCertID(cert);
            if (id != null) {
                System.out.println("OK,the id is:" + id);
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.privateEncryptPwd() and ReturnValue.publicDecryptCert()...");
            ciphertext = ReturnValue.privateEncryptPwd(plaintext, privateKey, "12345678".toCharArray());
            restoredPlaintext = ReturnValue.publicDecryptCert(ciphertext, cert);
            if (Arrays.equals(restoredPlaintext, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.publicEncryptCert() and ReturnValue.privateDecryptPwd()...");
            ciphertext = ReturnValue.publicEncryptCert(plaintext, cert);
            System.out.println("base64 pubkey is [" + new String(ReturnValue.base64enc(ciphertext)) + "]");
            restoredPlaintext = ReturnValue.privateDecryptPwd(ciphertext, privateKey, "12345678".toCharArray());
            if (Arrays.equals(restoredPlaintext, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.sign() and ReturnValue.verifySign()...");
            byte[] signature = ReturnValue.sign(plaintext, plaintext.length, privateKey, "12345678".toCharArray());
            int verifyit = ReturnValue.verifySign(plaintext, plaintext.length, cert, signature);
            if (verifyit == 0) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
            System.out.print("test ReturnValue.getPublicKey() and ReturnValue.getPrivateKey()...");
            byte[] priKey = ReturnValue.getPrivateKey(privateKey, "12345678".toCharArray());
            ciphertext = ReturnValue.privateEncrypt(plaintext, priKey);
            byte[] pubKey = ReturnValue.getPublicKey(cert);
            restoredPlaintext = ReturnValue.publicDecrypt(ciphertext, pubKey);
            if (Arrays.equals(restoredPlaintext, plaintext)) {
                System.out.println("OK");
            } else {
                System.out.println("Fail");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

