
package com.af.plugin;

import com.af.plugins.CommonTools;
import com.alibaba.fastjson.JSON;
import com.aote.ThreadResource;
import com.aote.rs.Server;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.Diagram;
import com.aote.workflow.perform.ProcessDefManager;
import org.apache.poi.ss.usermodel.DateUtil;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;

import java.sql.Timestamp;
import java.text.ParseException;
import  java.util.Date;
import  java.text.SimpleDateFormat;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ApplyUtils {

    private Lock lock  =new ReentrantLock() ;

    public static void main(String[] args) {
//        String value = "sss";
//        int value = 1;
//        System.out.println(checkType(value));
            JSONObject  jo= new JSONObject();
            jo.put("date","2019-07-12");
            jo.put("num",2);
            JSONArray ja= new JSONArray();
            ja.put(jo);

            System.out.println("JOSNArray:"+dateHandle(ja,"2019-07-10","2019-07-13"));
//        JSONObject jo = new JSONObject();
//        jo.put("s","2");
//        System.out.println("测试："+jo.get(jo.names().getString(0)));
    }
    public  String  getUserinfoid(SqlServer sql, String f_user_state) throws Exception{
        String userinfoid = "";
        lock.lock();
        try{
            //处理任务

            JSONArray getMax = sql.query(
                    "select isnull(cast(max(cast(f_userinfo_id as bigint)) as varchar), 0) as maxid from t_userinfo"
            );
            CommonTools commonTools = new CommonTools();
            String max =getMax.getJSONObject(0).getString("maxid");
            userinfoid =commonTools.strAdd(max, 1);
            int a = sql.runSQL("set identity_insert t_userinfo ON insert into t_userinfo (version,f_user_state,f_userinfo_id) values(1,'"+ f_user_state +"','"+ userinfoid +"')");
        }catch(Exception ex){

        }finally{
            lock.unlock();   //释放锁
        }
        return userinfoid;
    }
    /**
     *判断数据类型
     *
     * @param   row
     * @return   String
     */


    public static String  getAddress(JSONObject row ){
        String address="" + row.getString("f_area") + row.getString("f_slice_area") + row.getString("f_street")
                +row.getString("f_residential_area") + row.getString("f_building") + "号楼"
                + row.getString("f_unit") +"单元" +
                row.getString("f_floor") + "楼" + row.getString("f_room");
        return address;
    }

    public  static int calculateDate(String dateString) throws Exception{
        // 2020-02-04
         dateString=dateString.substring(0,10);
         Date date =formatDate(dateString,"yyyy-MM-dd");
        long time3 = new Date().getTime();
        long temp =time3-date.getTime();
        long oneYear = new Long("31557600000");
        int result =(int) (temp/oneYear);
        return  result;
    }

    public static String  checkType(Object value ){
        if(value instanceof Double){
            return "Double";
        }else if(value instanceof String){
            return  "String";
        }else if(value instanceof Boolean){
            return  "Boolean";
        }else if(value instanceof Long){
            return  "Long";
        }else if(value instanceof Integer){
            return  "Integer";
        }else if(value instanceof Float){
            return  "Float";
        }else if(value instanceof Short){
            return  "Short";
        }else if(value == null){
            return null;
        }else {
            return null;
        }
    }
    /**
     *判断数据类型
     *
     * @param   base      被比对字符串
     * @param   str        包含字符串
     * @return   String
     */
    public static boolean  includes(String base ,String  str){
        if(base!=null&&base.indexOf(str)!=-1){
            return true;
        }else {
            return false;
        }
    }


    /**
     * 将格式为dateFormat的日期字符串格式化为日期类型
     *
     * @param dateFormat 字符串的日期格式 eg：yyyy-MM-dd
     * @param date       需要格式化的字符串
     * @return
     * @throws ParseException
     */
    public static Date formatDate(String date, String dateFormat) throws ParseException {
        if("".equals(date) || date==null){
            return null;
        }else {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            return format.parse(date);
        }
    }


    // 生成用户编号字符串
    public static String  makeNumber(BigDecimal val){
        String valStr = val.toString();
        while(valStr.length()<10){
            valStr ='0'+valStr;
        }
        return valStr;
    }
    // 加法计算
    public static int add(BigDecimal a,int b){
        int temp1 = Integer.valueOf(a.toString());
    return  temp1+b;
    }

    // 字符串加法计算
    public static String bigDecimaAdd(String a,String b){
        BigDecimal b1=new BigDecimal(a);
        BigDecimal b2 = new BigDecimal(b);
        BigDecimal add = b1.add(b2);
        return  add.toString();
    }

    // 字符串减法计算
    public static String bigDecimaReduce(String a,String b){
        BigDecimal b1=new BigDecimal(a);
        BigDecimal b2 = new BigDecimal(b);
        BigDecimal reduce = b1.subtract(b2);
        return  reduce.toString();
    }

    // doubleToInt
    public static int doubleToInt(BigDecimal a){
       return  a.intValue();
    }

    /**
     * 组织updatesql语句
     *
     * @param   tableName,KYJsonObject,whereJsonObject
     * @return   JSONObject
     */
    public static String  updateString(String tableName,JSONObject KYJsonObject,JSONObject whereJsonObject){
        // 组织key value
        String KYString = "";
        for(String str:KYJsonObject.keySet()){
            if("String"==checkType(KYJsonObject.get(str))){
                KYString += str+"='"+KYJsonObject.get(str)+"',";
            }else if("Double"==checkType(KYJsonObject.get(str))||
                    "Long"==checkType(KYJsonObject.get(str))||
                    "Integer"==checkType(KYJsonObject.get(str))){
                KYString += str+"="+KYJsonObject.get(str)+",";
            }else if("JSONObject"==checkType(KYJsonObject.get(str))){
                KYString += str+"='"+KYJsonObject.get(str).toString()+"',";
            }else  if(null==checkType(KYJsonObject.get(str))){
                KYString += str+"=null,";
            }else{
                System.out.println("对不起ApplyUtils.updateStrubg()没有对key为"+str+"的值"+KYJsonObject.get(str)+"解析");
            }
        }
        KYString = KYString.substring(0,KYString.length()-1);
        // 组织where
        String whereString = "";
        for(String str:whereJsonObject.keySet()){
            if("String"==checkType(whereJsonObject.get(str))){
                whereString += str+"='"+whereJsonObject.get(str)+"',";
            }else if("Double"==checkType(whereJsonObject.get(str))||
                    "Long"==checkType(whereJsonObject.get(str))||
                    "Integer"==checkType(whereJsonObject.get(str))){
                whereString += str+"="+whereJsonObject.get(str)+",";
            }else if("JSONObject"==checkType(whereJsonObject.get(str))){
                whereString += str+"='"+whereJsonObject.get(str).toString()+"',";
            }else {
                System.out.println("对不起ApplyUtils.updateString()没有对key为"+str+"的值"+whereJsonObject.get(str)+"解析");
            }
        }
        whereString = whereString.substring(0,whereString.length()-1);
        String sqlString = " update "+tableName+" set "+KYString+ " where "+whereString;
        System.out.println("组织好的updatesql语句:"+sqlString);
        return sqlString;
    }


    /**
     * 组织updatesql语句,特殊方法
     * @param
     * @return   JSONObject
     */
    public static String  splicingUpdate(String tableName,JSONArray keyArray,JSONObject valJson,String condition){
        // 组织key value
        String KYString = "";
        String str = "";
        JSONObject item = null;
        for(int i=0;i<keyArray.length();i++){
            item = keyArray.getJSONObject(i);
            str = item.getString("field");
            if(valJson.isNull(str)){
                KYString += str + "=null,";
            }else if("String"==checkType(valJson.get(str))){
                KYString += str+"='"+valJson.get(str)+"',";
            }else if("Double"==checkType(valJson.get(str))||
                    "Long"==checkType(valJson.get(str))||
                    "Integer"==checkType(valJson.get(str))){
                KYString += str+"="+valJson.get(str)+",";
            }else if("JSONObject"==checkType(valJson.get(str))){
                KYString += str+"='"+valJson.get(str).toString()+"',";
            }else{
                System.out.println("对不起ApplyUtils.updateStrubg()没有对key为"+str+"的值"+valJson.get(str)+"解析");
            }
        }
        KYString = KYString.substring(0,KYString.length()-1);
        String sqlString = " update "+tableName+" set "+KYString+ " where "+ condition;
        System.out.println("组织好的updatesql语句:"+sqlString);
        return sqlString;
    }

    /**
     * 组织save数据,特殊方法
     * @param
     * @return   JSONObject
     */
    public static JSONObject splicingEntity(JSONArray keys,JSONObject oldInfo,JSONObject newInfo, JSONObject loginUser){
        String str = "";
        JSONObject item = null;
        JSONObject result = new JSONObject();
        for(int i=0;i<keys.length();i++){
            item = keys.getJSONObject(i);
            str = item.getString("field");
            if(!newInfo.isNull(str)){
                result.put(str + "_new", newInfo.get(str));
            }
            if(!oldInfo.isNull(str)){
                result.put(str + "_old", oldInfo.get(str));
            }
        }
        result.put("f_changer_id", loginUser.get("id") + "");
        result.put("f_changer_name", loginUser.get("name") + "");
        result.put("f_changer_network", loginUser.get("f_parentname") + "");
        result.put("f_changer_filiale", loginUser.get("f_fengongsi") + "");
        result.put("f_apply_num", newInfo.getString("f_apply_num") + "");
        result.put("f_process_id", newInfo.getString("f_process_id") + "");
        result.put("f_defname", newInfo.getString("defname") + "");
        System.out.println("组织好的updatesql语句:" + result.toString());
        return result;
    }

    /**
     * 组织updatesql语句,特殊方法
     */
    public static String  getUpdateUserinfoSql(JSONObject jo){
        String sql = "update t_userinfo set ";
        if(!jo.isNull("f_idnumber")){
            sql += "f_idnumber='" + jo.getString("f_idnumber") + "',";
        }
        if(!jo.isNull("f_gas_type")){
            sql += "f_gasproperties='" + jo.getString("f_gas_type") + "',";
        }
        if(!jo.isNull("f_contact")){
            sql += "f_user_name='" + jo.getString("f_contact") + "',";
        }
        if(!jo.isNull("f_phone")){
            sql += "f_user_phone='" + jo.getString("f_phone") + "',";
        }
        if(!jo.isNull("f_address")){
            sql += "f_address='" + jo.getString("f_address") + "',";
        }
        if(!jo.isNull("f_population")){
            sql += "f_people_num='" + jo.getString("f_population") + "',";
        }
        if(!jo.isNull("f_area")){
            if( jo.get("f_area").toString().startsWith("{")){
                JSONObject f_area = (JSONObject) jo.get("f_area");
                sql += "f_area='" + f_area.getString("name") + "',";
                sql += "f_area_id=" + f_area.getInt("id") + ",";
            }else {

            }

        }
        if(!jo.isNull("f_address_town")){
            if( jo.get("f_address_town").toString().startsWith("{")) {
                JSONObject f_address_town = (JSONObject) jo.get("f_address_town");
                sql += "f_slice_area='" + f_address_town.getString("name") + "',";
            }else {
                sql += "f_slice_area='" + jo.get("f_address_town").toString() + "',";
            }

        }
        if(!jo.isNull("f_street")){
            if( jo.get("f_street").toString().startsWith("{")) {
                JSONObject f_street = (JSONObject) jo.get("f_street");
                sql += "f_street='" + f_street.getString("name") + "',";
            }else{
                sql += "f_street='" + jo.get("f_street").toString() + "',";
            }
        }
        if(!jo.isNull("f_residential_area")){
            if( jo.get("f_residential_area").toString().startsWith("{")) {
                JSONObject f_residential_area = (JSONObject) jo.get("f_residential_area");
                sql += "f_residential_area='" + f_residential_area.getString("name") + "',";
            }else{
                sql += "f_residential_area='" + jo.get("f_residential_area").toString() + "',";
            }
        }
        if(!jo.isNull("f_building")){
            sql += "f_building='" + jo.getString("f_building") + "',";
        }
        if(!jo.isNull("f_floor")){
            sql += "f_floor='" + jo.getString("f_floor") + "',";
        }
        if(!jo.isNull("f_unit")){
            sql += "f_unit='" + jo.getString("f_unit") + "',";
        }
        if(!jo.isNull("f_room")){
            sql += "f_room='" + jo.getString("f_room") + "',";
        }
        sql = sql.substring(0,sql.length()-1);
        sql += " where f_apply_num='" + jo.getString("f_apply_num") + "'";
        System.out.println("getUpdateUserinfoSql生成的updatesql语句:" + sql);
        return sql;
    }


    /**
     * 组织insertsql语句
     *
     * @param   tableName,KYJsonObject,whereJsonObject
     * @return   JSONObject
     */
    public static String  insertString(String tableName,JSONObject KYJsonObject){
        // 组织key value
        String KString = "";
        String YString = "";
        for(String str:KYJsonObject.keySet()){
            KString+=str+",";
            if("String"==checkType(KYJsonObject.get(str))){
                YString += "'"+KYJsonObject.get(str)+"',";
            }else if("Double"==checkType(KYJsonObject.get(str))||
                    "Long"==checkType(KYJsonObject.get(str))||
                    "Integer"==checkType(KYJsonObject.get(str))){
                YString += KYJsonObject.get(str)+",";
            }else if("JSONObject"==checkType(KYJsonObject.get(str))){
                YString += "'"+KYJsonObject.get(str).toString()+"',";
            }else if(null==checkType(KYJsonObject.get(str))){
                YString += "null,";
            }else{
                System.out.println("对不起ApplyUtils.updateString()没有对key为"+str+"的值"+KYJsonObject.get(str)+"解析");
            }
        }
        KString = KString.substring(0,KString.length()-1);
        YString = YString.substring(0,YString.length()-1);
        // INSERT INTO table_name (列1, 列2,...) VALUES (值1, 值2,....)
        String sqlString = " insert into "+tableName+"  ( "+KString+ " ) VALUES ("+YString+")";
        System.out.println("组织好的insertsql语句:"+sqlString);
        return sqlString;
    }

    /**
     *  用于获取用户目录
     *
     * @param
     * @return   String
     */
    public static String  getOrganizationID(String orgids){
         String[] orgidArray = orgids.split("\\.");
         return  orgidArray[orgidArray.length-1];
    }

    public static String  getUserDir(String userDir,String jsonPath){
        URL url =ApplyUtils.class.getClassLoader().getResource(userDir);
        if(url!=null&&url.getPath()!=null){
            return userDir+"/"+jsonPath;
        }else {
            return jsonPath;
        }
    }

    /**
     *  综合管理平台接口每一天的时间处理
     *
     * @param   jsonArray   要处理的json数组
     * @param   startDate   开始时间
     * @param   stopDate    结束时间
     * @return   String
     */
    public static JSONArray  dateHandle(JSONArray  jsonArray,String startDate,String stopDate) {
        JSONArray ja = new JSONArray();
        try {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = format.parse(startDate);
        Date end = format.parse(stopDate); //结束日期
        Date tempDate = begin;
        while (tempDate.compareTo(end)<=0){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("date",format.format(tempDate));
            jsonObject.put("count",0);
            ja.put(jsonObject);
            tempDate  =  new Date(tempDate.getTime()+24*3600*1000);
        }
        for(int i=0;i<ja.length();i++){
           for(int j=0;j<jsonArray.length();j++){
               Date date1 = format.parse(new JSONObject(ja.get(i).toString()).get("date").toString());
               Date date2 = format.parse(new JSONObject(jsonArray.get(j).toString()).get("date").toString());
               if( date1.compareTo(date2)==0){
                   ja.put(i,jsonArray.get(j));
                   break;
               }
           }
        }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return ja;
    }
    /**
     * 去除jsonObject中的id
     * @param   jsonObject   要清理处理的json数组
     * @return   JSONObject
     */
    public static JSONObject  deleteID(JSONObject  jsonObject) {
        if(jsonObject.has("id")){
            jsonObject.remove("id");
        }
        return jsonObject;
    }
}


