/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugin;

import com.af.plugins.JsonTools;
import com.aote.workflow.perform.ActivityDef;
import com.aote.workflow.perform.ProcessDef;
import com.aote.workflow.perform.ProcessDefManager;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApplyUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm", "yyyyMMdd"};
    private Lock lock = new ReentrantLock();

    public static boolean similar(JSONArray array, JSONObject item) {
        List list = array.toList();
        HashMap map = JsonTools.toHashMap((JSONObject)item);
        return list.contains(map);
    }

    public static JSONObject getActivity(String processName, String id) {
        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(processName);
        ActivityDef ad = process.getActivity(id);
        JSONObject json = new JSONObject();
        json.put("id", (Object)ad.getID());
        json.put("name", (Object)ad.getName());
        json.put("personExpression", (Object)ad.getPersonExpression());
        json.put("timeout", (Object)ad.getTimeout());
        json.put("nodetype", (Object)ad.getNodetype());
        return json;
    }

    public static JSONArray getDefnames(String name) {
        JSONArray array = new JSONArray();
        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
        List list = process.getActivities();
        list.forEach(item -> {
            ActivityDef def = (ActivityDef)item;
            JSONObject object = new JSONObject();
            object.put("label", (Object)def.getName());
            object.put("value", (Object)def.getName());
            array.put((Object)object);
        });
        return array;
    }

    public static void main(String[] args) throws Exception {
    }

    public static String toString(int val) {
        return new Integer(val).toString();
    }

    public static String toString(Object obj) {
        return obj.toString();
    }

    public static String checkDatas(JSONArray row) {
        String res = "1";
        for (int i = 0; i < row.length(); ++i) {
            for (int j = 0; j < row.length(); ++j) {
                String b;
                String a;
                if (i == j || (a = row.getJSONObject(i).getJSONObject("t_userfiles").getString("f_meternumber")) != (b = row.getJSONObject(j).getJSONObject("t_userfiles").getString("f_meternumber"))) continue;
                res = a;
            }
        }
        return res;
    }

    public static String getAddress(JSONObject row) {
        String address = "" + row.getString("f_residential_area") + row.getString("f_building") + "\u53f7\u697c" + row.getString("f_unit") + "\u5355\u5143" + row.getString("f_floor") + "\u697c" + row.getString("f_room");
        return address;
    }

    public static String parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            Date date = DateUtils.parseDate((String)string, (String[])parsePatterns);
            String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
            if (date.getDay() > 31) {
                throw new ParseException("\u65e5\u671f\u4e0d\u5408\u6cd5", 500);
            }
            if (date.getMonth() > 12) {
                throw new ParseException("\u6708\u4efd\u4e0d\u5408\u6cd5", 500);
            }
            return dateStr;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String checkType(Object value) {
        if (value instanceof Double) {
            return "Double";
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof Long) {
            return "Long";
        }
        if (value instanceof Integer) {
            return "Integer";
        }
        if (value instanceof Float) {
            return "Float";
        }
        if (value instanceof Short) {
            return "Short";
        }
        if (value instanceof JSONObject) {
            return "JSONObject";
        }
        if (value == null) {
            return null;
        }
        return null;
    }

    public static boolean includes(String base, String str) {
        if (base != null && base.indexOf(str) != -1) {
            "".contains("qweqwe");
            return true;
        }
        return false;
    }

    public static JSONObject jsonValueToString(JSONObject jsonObject) {
        for (int i = 0; i < jsonObject.names().length(); ++i) {
            String str = jsonObject.names().get(i).toString();
            if ("JSONObject" != ApplyUtils.checkType(jsonObject.get(str))) continue;
            jsonObject.put(str, (Object)jsonObject.get(str).toString());
        }
        return jsonObject;
    }

    public static String makeNumber(BigDecimal val) {
        String valStr = val.toString();
        while (valStr.length() < 10) {
            valStr = '0' + valStr;
        }
        return valStr;
    }

    public static String makeNumberString(Object val, int length) {
        String valStr = val.toString();
        while (valStr.length() < length) {
            valStr = '0' + valStr;
        }
        return valStr;
    }

    public static int add(BigDecimal a, int b) {
        int temp1 = Integer.valueOf(a.toString());
        return temp1 + b;
    }

    public static String bigDecimaAdd(String a, String b) {
        BigDecimal b1 = new BigDecimal(a);
        BigDecimal b2 = new BigDecimal(b);
        BigDecimal add = b1.add(b2);
        return add.toString();
    }

    public static String bigDecimaReduce(String a, String b) {
        BigDecimal b1 = new BigDecimal(a);
        BigDecimal b2 = new BigDecimal(b);
        BigDecimal reduce = b1.subtract(b2);
        return reduce.toString();
    }

    public static String getOrganizationID(String orgids) {
        String[] orgidArray = orgids.split("\\.");
        return orgidArray[orgidArray.length - 1];
    }

    public static String getUserDir(String userDir, String jsonPath) {
        URL url = ApplyUtils.class.getClassLoader().getResource(userDir);
        if (url != null && url.getPath() != null) {
            return userDir + "/" + jsonPath;
        }
        return jsonPath;
    }

    public static JSONArray dateHandle(JSONArray jsonArray, String startDate, String stopDate) {
        JSONArray ja = new JSONArray();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin = format.parse(startDate);
            Date end = format.parse(stopDate);
            Date tempDate = begin;
            while (tempDate.compareTo(end) <= 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("date", (Object)format.format(tempDate));
                jsonObject.put("count", 0);
                ja.put((Object)jsonObject);
                tempDate = new Date(tempDate.getTime() + 86400000L);
            }
            block3: for (int i = 0; i < ja.length(); ++i) {
                for (int j = 0; j < jsonArray.length(); ++j) {
                    Date date2;
                    Date date1 = format.parse(new JSONObject(ja.get(i).toString()).get("date").toString());
                    if (date1.compareTo(date2 = format.parse(new JSONObject(jsonArray.get(j).toString()).get("date").toString())) != 0) continue;
                    ja.put(i, jsonArray.get(j));
                    continue block3;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ja;
    }

    public static JSONObject deleteID(JSONObject jsonObject) {
        if (jsonObject.has("id")) {
            jsonObject.remove("id");
        }
        return jsonObject;
    }

    public static JSONArray importArray(String tablename, JSONArray targetArray, JSONObject jsonObject) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < targetArray.length(); ++i) {
            JSONObject jsontemp = (JSONObject)targetArray.get(i);
            jsontemp = (JSONObject)jsontemp.get(tablename);
            for (String key : jsonObject.keySet()) {
                jsontemp.put(key, jsonObject.get(key));
            }
            JSONObject jo = new JSONObject();
            jo.put(tablename, (Object)jsontemp);
            jsonArray.put(i, (Object)jo);
        }
        return jsonArray;
    }

    public static JSONObject getJO(JSONObject targetObject, String tablename) {
        return (JSONObject)targetObject.get(tablename);
    }

    public static String getSpecialChar(int index) {
        String res;
        switch (index) {
            case 0: {
                res = "$";
                break;
            }
            case 1: {
                res = "//";
                break;
            }
            case 2: {
                res = "-";
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }

    public static String splicing(String delimiter, JSONArray elements) {
        return StringUtils.join((Iterable)elements, (String)delimiter);
    }
}

