package com.af.websocket;

import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WebSocketServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException {

        this.doPost(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException {

        WebSocketHttpRequestHandler handler = new WebSocketHttpRequestHandler(new MyWebSocketHandler());

        List<HandshakeInterceptor> interceptors = new ArrayList<HandshakeInterceptor>();
        interceptors.add(new WebSocketHandshakeInterceptor());

        handler.setHandshakeInterceptors(interceptors);

        handler.handleRequest(req, resp);
    }
}
