package com.af.websocket;

import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.socket.*;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MyWebSocketHandler implements WebSocketHandler {

    private static final Map<String, WebSocketSession> users;

    static {
        users = new HashMap<String, WebSocketSession>();
    }

    //建立连接后
    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        System.out.println("建立连接后");
        Object token = session.getAttributes().get("token");
        users.put(session.getId(), session);
        System.out.println(token);
//        session.sendMessage(new TextMessage(token+"链接成功!!"));
//        sendMessageToAllUser(token+"上线了");
    }

    // 处理客户端发送信息
    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        if (message.getPayload().equals("ping")) {
            System.out.println("ping");
            session.sendMessage(new TextMessage("pong"));
            return;
        }
        System.out.println("处理信息");
    }

    // 处理传输时异常
    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        System.out.println("处理传输时异常");
        if (session.isOpen()) {
            session.close();
        }
        users.remove(session.getId());
    }

    // 关闭 连接时
    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        System.out.println("连接关闭");
        users.remove(session.getId());
    }

    // 是否支持分包
    @Override
    public boolean supportsPartialMessages() {
        return false;
    }

    /**
     * 发送消息给指定用户
     * @param users     接收者
     * @param type      消息类型
     * @param message   提示信息
     * @param data      携带参数
     * @param sender    发送者
     */
    public void sendMessageToUsers(JSONArray users,String type,String message,Object data,String sender) {
        users.forEach(item -> {
            sendMessageToUser(item.toString(),type,message,data,sender);
        });
    }

    /**
     * 发送消息给某个指定用户
     * @param token     接收者
     * @param type      消息类型
     * @param message   提示信息
     * @param data      携带参数
     * @param sender    发送者
     */
    public void sendMessageToUser(String token,String type,String message,Object data,String sender) {
        JSONObject json = new JSONObject();
        json.put("type",type);
        json.put("message",message);
        json.put("data",data);
        json.put("sender",sender);
        Iterator<Map.Entry<String, WebSocketSession>> it = userIterator();
        while (it.hasNext()) {
            WebSocketSession session = it.next().getValue();
            if (token.equals(session.getAttributes().get("token"))) {
                try {
                    if (session.isOpen())
                        session.sendMessage(new TextMessage(json.toString()));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 发送消息给所有用户
     * @param type      消息类型
     * @param message   提示信息
     * @param data      携带参数
     * @param sender    发送者
     */
    public void sendMessageToAllUser(String type,String message,Object data,String sender) {
        JSONObject json = new JSONObject();
        json.put("type",type);
        json.put("message",message);
        json.put("data",data);
        json.put("sender",sender);
        Iterator<Map.Entry<String, WebSocketSession>> it = userIterator();
        while (it.hasNext()) {
            WebSocketSession session = it.next().getValue();
            try {
                if (session.isOpen())
                    session.sendMessage(new TextMessage(json.toString()));
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public JSONArray onlineUser() {

        JSONArray array = new JSONArray();
        Iterator<Map.Entry<String, WebSocketSession>> it = userIterator();
        while (it.hasNext()) {
            WebSocketSession session = it.next().getValue();
            array.put(session.getAttributes().get("token"));
        }
        return array;
    }

    /**
     * 在线用户
     * @return
     */
    private Iterator<Map.Entry<String, WebSocketSession>> userIterator() {
        Set<Map.Entry<String, WebSocketSession>> entrys = users.entrySet();
        return entrys.iterator();
    }
}
