
package com.af.plugin;

import com.af.plugins.CommonTools;
import com.af.plugins.JsonTools;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.workflow.perform.ActivityDef;
import com.aote.workflow.perform.ProcessDef;
import com.aote.workflow.perform.ProcessDefManager;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.*;
import  java.text.SimpleDateFormat;

import java.math.BigDecimal;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.DateUtils;
import com.aote.workflow.*;

public class ApplyUtils {


    private static String[] parsePatterns = {
            "yyyy-MM-dd",
            "yyyy年MM月dd日",
            "yyyy-MM-dd HH:mm:ss",
            "yyyy-MM-dd HH:mm:ss.SSS",
            "yyyy-MM-dd HH:mm",
            "yyyy/MM/dd",
            "yyyy/MM/dd HH:mm:ss",
            "yyyy/MM/dd HH:mm:ss.SSS",
            "yyyy/MM/dd HH:mm",
            "yyyyMMdd"
    };

    private Lock lock  =new ReentrantLock() ;

    /**
     * 判断JSONArray是否有重复值
     * @param array
     * @param item
     * @return
     */
    public static boolean similar(JSONArray array, JSONObject item){

        List<Object> list = array.toList();

        HashMap<String, Object> map = JsonTools.toHashMap(item);

        return list.contains(map);
    }

    /**
     * 获取下一个节点名称
     * @param    processName 流程名字
     * @param    id 活动id号
     * @return   JSONArray
     */
    public static JSONObject getActivity(String processName,String id){
        // 得到流程定义
        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(processName);
        ActivityDef ad = process.getActivity(id);
        JSONObject json = new JSONObject();
        json.put("id",ad.getID());
        json.put("name",ad.getName());
        json.put("personExpression",ad.getPersonExpression());
        json.put("timeout",ad.getTimeout());
        json.put("nodetype",ad.getNodetype());
        return json;
    }

    /**
     * 获取节点名称
     * @param name 流程配置文件名
     * @return
     */
    public static JSONArray getDefnames(String name){
        JSONArray array = new JSONArray();

        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
        List list = process.getActivities();
        list.forEach(item -> {
            ActivityDef def = (ActivityDef)item;
            JSONObject object = new JSONObject();
//            object.put("name",def.getName());
//            object.put("person",def.getPersonExpression());
            object.put("label",def.getName());
            object.put("value",def.getName());
            array.put(object);
        });

        return array;
    }

    public static void main(String[] args) throws Exception{

    }


    /**
     * 转string
     *
     * @param   val
     * @return   string
     */
    public static String  toString(int val){
        return  new Integer(val).toString();
    }

    /**
     * 转string
     *
     * @param   obj
     * @return   string
     */
    public static String  toString(Object obj){
        return  obj.toString();
    }

    /**
     *判断数据类型
     *
     * @param   row
     * @return   String
     */
    public static String  checkDatas(JSONArray row ){
        String res ="1";
        for (int i=0;i<row.length();i++){
            for (int j=0;j<row.length();j++){
                if (i!=j){
                    String a= row.getJSONObject(i).getJSONObject("t_userfiles").getString("f_meternumber");
                    String b = row.getJSONObject(j).getJSONObject("t_userfiles").getString("f_meternumber");
                    if (a==b){
                        res=a;
                    }
                }

            }
        }
        return res;
    }
    public static String  getAddress(JSONObject row ){
        String address="" + row.getString("f_residential_area") + row.getString("f_building") + "号楼"
                + row.getString("f_unit") +"单元" +
                row.getString("f_floor") + "楼" + row.getString("f_room");
        return address;
    }

    /**
     *
     * @param string  时间字符串
     * @return
     */

    public static String parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            Date date = DateUtils.parseDate(string, parsePatterns);
            String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
            if(date.getDay()>31){
                throw  new ParseException("日期不合法",500);
            }
            if(date.getMonth()>12){
                throw  new ParseException("月份不合法",500);
            }
//            SimpleDateFormat sd=new SimpleDateFormat("yyyy-MM-dd");
//            Date date2 = sd.parse(dateStr);
            return dateStr;
        } catch (ParseException e) {
            return null;
        }
    }



    public static String  checkType(Object value ){
        if(value instanceof Double){
            return "Double";
        }else if(value instanceof String){
            return  "String";
        }else if(value instanceof Boolean){
            return  "Boolean";
        }else if(value instanceof Long){
            return  "Long";
        }else if(value instanceof Integer){
            return  "Integer";
        }else if(value instanceof Float){
            return  "Float";
        }else if(value instanceof Short){
            return  "Short";
        }else if(value instanceof JSONObject){
            return  "JSONObject";
        }else if(value == null){
            return null;
        }else {
            return null;
        }
    }

    /**
     *判断数据类型
     *
     * @param   base      被比对字符串
     * @param   str        包含字符串
     * @return   String
     */
    public static boolean  includes(String base ,String  str){
        if(base!=null&&base.indexOf(str)!=-1){
            "".contains("qweqwe");
            return true;
        }else {
            return false;
        }
    }

    /**
     *将value为json的数据转换为字符串，将json数据保存到数据库中
     *
     * @param   jsonObject      传入jsonObject
     * @return                            传出jsonObject
     */
    public static JSONObject  jsonValueToString(JSONObject jsonObject){
        for(int i=0;i<jsonObject.names().length();i++){
            String str = jsonObject.names().get(i).toString();

            if("JSONObject" == checkType(jsonObject.get(str))){
                jsonObject.put(str,jsonObject.get(str).toString());
            }
        }
        return jsonObject;
    }


    // 特殊


    // 生成用户编号字符串
    public static String  makeNumber(BigDecimal val){
        String valStr = val.toString();
        while(valStr.length()<10){
            valStr ='0'+valStr;
        }
        return valStr;
    }

    public static String  makeNumberString(Object val,int  length){
        String valStr = val.toString();
        while(valStr.length()<length){
            valStr ='0'+valStr;
        }
        return valStr;
    }

    // 加法计算
    public static int add(BigDecimal a,int b){
        int temp1 = Integer.valueOf(a.toString());
        return  temp1+b;
    }

    // 字符串加法计算
    public static String bigDecimaAdd(String a,String b){
        BigDecimal b1=new BigDecimal(a);
        BigDecimal b2 = new BigDecimal(b);
        BigDecimal add = b1.add(b2);
        return  add.toString();
    }

    // 字符串减法计算
    public static String bigDecimaReduce(String a,String b){
        BigDecimal b1=new BigDecimal(a);
        BigDecimal b2 = new BigDecimal(b);
        BigDecimal reduce = b1.subtract(b2);
        return  reduce.toString();
    }

    /**
     *  用于获取用户目录
     *
     * @param
     * @return   String
     */
    public static String  getOrganizationID(String orgids){
        String[] orgidArray = orgids.split("\\.");
        return  orgidArray[orgidArray.length-1];
    }

    public static String  getUserDir(String userDir,String jsonPath){
        URL url =ApplyUtils.class.getClassLoader().getResource(userDir);
        if(url!=null&&url.getPath()!=null){
            return userDir+"/"+jsonPath;
        }else {
            return jsonPath;
        }
    }

    /**
     *  综合管理平台接口每一天的时间处理
     *
     * @param   jsonArray   要处理的json数组
     * @param   startDate   开始时间
     * @param   stopDate    结束时间
     * @return   String
     */
    public static JSONArray  dateHandle(JSONArray  jsonArray,String startDate,String stopDate) {
        JSONArray ja = new JSONArray();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin = format.parse(startDate);
            Date end = format.parse(stopDate); //结束日期
            Date tempDate = begin;
            while (tempDate.compareTo(end)<=0){
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("date",format.format(tempDate));
                jsonObject.put("count",0);
                ja.put(jsonObject);
                tempDate  =  new Date(tempDate.getTime()+24*3600*1000);
            }
            for(int i=0;i<ja.length();i++){
                for(int j=0;j<jsonArray.length();j++){
                    Date date1 = format.parse(new JSONObject(ja.get(i).toString()).get("date").toString());
                    Date date2 = format.parse(new JSONObject(jsonArray.get(j).toString()).get("date").toString());
                    if( date1.compareTo(date2)==0){
                        ja.put(i,jsonArray.get(j));
                        break;
                    }
                }
            }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return ja;
    }
    /**
     * 去除jsonObject中的id
     * @param   jsonObject   要清理处理的json数组
     * @return   JSONObject
     */
    public static JSONObject  deleteID(JSONObject  jsonObject) {
        if(jsonObject.has("id")){
            jsonObject.remove("id");
        }
        return jsonObject;
    }

    /**
     * 公共excel文件导入
     * 前面第一个参数是表名,第二个参数是jsonArray,最后一个参数是jsonobject
     * @param   jsonObject   要清理处理的json数组
     * @return   JSONObject
     */
    public static JSONArray  importArray(String tablename,JSONArray targetArray,JSONObject  jsonObject) {
        JSONArray jsonArray= new JSONArray();
        for(int i=0;i<targetArray.length();i++){
            JSONObject jsontemp= (JSONObject)targetArray.get(i);
            jsontemp =  (JSONObject) jsontemp.get(tablename);
            for (String key: jsonObject.keySet()) {
                jsontemp.put(key,jsonObject.get(key));
            }
            JSONObject jo = new JSONObject();
            jo.put(tablename,jsontemp);
            jsonArray.put(i,jo);
        }
        return jsonArray;
    }

    public static JSONObject  getJO(JSONObject targetObject,String tablename) {
        return (JSONObject)targetObject.get(tablename);
    }

    /**
     * 返回特殊字符  $
     * @return
     */
    public static String getSpecialChar(int index) {
        String res;
        switch (index) {
            case 0:
                res = "$";
                break;
            case 1:
                res = "//";
                break;
            case 2:
                res = "-";
                break;
            default:
                res = "";
        }
        return res;
    }

    /**
     * 根据特定字符拼接
     * @param delimiter
     * @param elements
     * @return
     */
    public static String splicing(String delimiter, JSONArray elements) {

        return StringUtils.join(elements, delimiter);
    }

}
