package com.aote.plugins;

import com.af.plugins.DateTools;
import com.aote.entity.EntityServer;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import kafka.utils.Json;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

public class AddressImport {
    static Logger log = Logger.getLogger(AddressImport.class);
    /**
     * 导入用户地址
     * @return 成功导入条数
     * data 本次导入的地址
     */
    public int importUserAddress(JSONArray data,EntityServer entity,JSONObject user, SqlServer sql) throws Exception {
        long begin = System.currentTimeMillis();
        //当前时间
        String date = DateTools.getNow2();
        //每次保存的地址
        JSONObject saveAddress;
        //获取省市区信息
        HashMap<String, JSONObject> pcdlist=this.getPcdList(sql);
        //获取街道信息
        HashMap<String, JSONObject> streetlist=this.getStreetList(sql);
        //获取小区信息
        HashMap<String, JSONObject> arealist=this.getAreaList(sql);
        int n = 0;
        int success=0;
        for(Object o : data){
            JSONObject json = (JSONObject) o;
            saveAddress = new JSONObject();
            saveAddress.put("f_create_person",user.getString("name"));
            saveAddress.put("f_filiale",user.getString("f_fengongsi"));
            saveAddress.put("f_outlets",user.getString("f_parentname"));
            saveAddress.put("f_orgstr",user.getString("orgpathstr"));
            saveAddress.put("f_filialeids",user.getString("f_orgids"));
            JSONObject address = json.getJSONObject("t_user_address");
            //取出数据
            String f_pcd = address.optString("f_pcd");
            String f_street = address.optString("f_street");
            String f_residential_area = address.optString("f_residential_area");
            Integer f_pcd_id;
            Integer f_street_id;
            Integer f_residential_area_id;
            //省市区暂不新加
            if(pcdlist.containsKey(f_pcd)){
                f_pcd_id=((JSONObject)pcdlist.get(f_pcd)).getInt("id");
            }else {
                f_pcd_id=null;
            }
            //判断是否有此街道
            if(streetlist.containsKey(f_street)){
                f_street_id=((JSONObject)streetlist.get(f_street)).getInt("id");
            }else {
                JSONObject streetjson = new JSONObject();
                streetjson.put("f_operator",user.getString("name"));
                streetjson.put("f_filiale",user.getString("f_fengongsi"));
                streetjson.put("f_outlets",user.getString("f_parentname"));
                streetjson.put("f_orgstr",user.getString("orgpathstr"));
                streetjson.put("f_filialeids",user.getString("f_orgids"));
                streetjson.put("f_pcd",f_pcd);
                streetjson.put("f_pcd_id",f_pcd_id);
                streetjson.put("f_street",f_street);
                f_street_id=Integer.parseInt(new JSONObject(entity.partialSave("t_street",streetjson)).getString("id"));
                streetjson.put("id",f_street_id);
                streetjson.put("value",f_street);
                //新增的加入比对队列
                streetlist.put(f_street,streetjson);
            }
            //判断是否有此小区
            if(arealist.containsKey(f_residential_area)){
                f_residential_area_id=((JSONObject)arealist.get(f_residential_area)).getInt("id");
            }else {
                JSONObject areajson = new JSONObject();
                areajson.put("f_operator",user.getString("name"));
                areajson.put("f_filiale",user.getString("f_fengongsi"));
                areajson.put("f_outlets",user.getString("f_parentname"));
                areajson.put("f_orgstr",user.getString("orgpathstr"));
                areajson.put("f_filialeids",user.getString("f_orgids"));
                areajson.put("f_pcd",f_pcd);
                areajson.put("f_pcd_id",f_pcd_id);
                areajson.put("f_street",f_street);
                areajson.put("f_street_id",f_street_id);
                areajson.put("f_residential_area",f_residential_area);
                areajson.put("f_area_address",f_pcd+f_street);
                f_residential_area_id=Integer.parseInt(new JSONObject(entity.partialSave("t_area",areajson)).getString("id"));
                areajson.put("id",f_residential_area_id);
                areajson.put("value",f_residential_area);
                //新增的加入比对队列
                arealist.put(f_residential_area,areajson);
            }
            saveAddress.put("f_pcd_id",f_pcd_id);
            saveAddress.put("f_street_id",f_street_id);
            saveAddress.put("f_residential_area_id",f_residential_area_id);
            String f_building = address.optString("f_building");
            String f_unit = address.optString("f_unit");
            String f_floor = address.optString("f_floor");
            String f_room = address.optString("f_room");
            String f_address = f_pcd+f_street+f_residential_area;
            if(f_building.length()>0){
                String f_building_suffix = "栋";
                saveAddress.put("f_building_suffix",f_building_suffix);
                f_address=f_address+ f_building+f_building_suffix;
            }
            if(f_unit.length()>0){
                String f_unit_suffix = "单元";
                saveAddress.put("f_unit_suffix",f_unit_suffix);
                f_address=f_address+ f_unit+f_unit_suffix;
            }
            if(f_floor.length()>0){
                String f_floor_suffix = "层";
                saveAddress.put("f_floor_suffix",f_floor_suffix);
                f_address=f_address+ f_floor+f_floor_suffix;
            }
            if(f_building.length()>0){
                String f_room_suffix = "室";
                saveAddress.put("f_room_suffix",f_room_suffix);
                f_address=f_room+ f_building+f_room_suffix;
            }
            saveAddress.put("f_pcd",f_pcd);
            saveAddress.put("f_street",f_street);
            saveAddress.put("f_residential_area",f_residential_area);
            saveAddress.put("f_unit",f_unit);
            saveAddress.put("f_room",f_room);
            saveAddress.put("f_floor",f_floor);
            saveAddress.put("f_building",f_building);
            saveAddress.put("f_address",f_address);
            saveAddress.put("f_create_date",date);
            try {
                entity.partialSave("t_user_address",saveAddress);
                success++;
            } catch (WebException e){
                log.warn("插入一条数据异常"+e.getMessage());
            }
            n++;
        }
        long end = System.currentTimeMillis();
        System.out.println("导入"+n+"条,耗时"+(end-begin));
        System.out.println("成功"+success+"条");
        return n;
    }

    //返回省市区信息
    public  HashMap<String, JSONObject> getPcdList(SqlServer sql)throws Exception{
        HashMap<String, JSONObject> result=new HashMap<String, JSONObject>();
        JSONArray sqldata=sql.query("select * from t_pcd");
        for(Object o : sqldata){
            JSONObject onedata = (JSONObject) o;
            String colunmname=onedata.getString("f_pcd");
            JSONObject json = new JSONObject();
            json.put("id",onedata.getInt("id"));
            json.put("value",colunmname);
            result.put(colunmname,json);
        }
        return result;
    }

    //返回街道信息
    public  HashMap<String, JSONObject> getStreetList(SqlServer sql)throws Exception{
        HashMap<String, JSONObject> result=new HashMap<String, JSONObject>();
        JSONArray sqldata=sql.query("select * from t_street");
        for(Object o : sqldata){
            JSONObject onedata = (JSONObject) o;
            String colunmname=onedata.getString("f_street");
            JSONObject json = new JSONObject();
            json.put("id",onedata.getInt("id"));
            json.put("value",colunmname);
            json.put("f_pcd_id",onedata.getInt("f_pcd_id"));
            json.put("f_pcd",onedata.getString("f_pcd"));
            result.put(colunmname,json);
        }
        return result;
    }

    //返回小区信息
    public  HashMap<String, JSONObject> getAreaList(SqlServer sql)throws Exception{
        HashMap<String, JSONObject> result=new HashMap<String, JSONObject>();
        JSONArray sqldata=sql.query("select * from t_area");
        for(Object o : sqldata){
            JSONObject onedata = (JSONObject) o;
            String colunmname=onedata.getString("f_residential_area");
            JSONObject json = new JSONObject();
            json.put("id",onedata.getInt("id"));
            json.put("value",colunmname);
            json.put("f_pcd_id",onedata.getInt("f_pcd_id"));
            json.put("f_pcd",onedata.getString("f_pcd"));
            json.put("f_street_id",onedata.getInt("f_street_id"));
            json.put("f_street",onedata.getString("f_street"));
            result.put(colunmname,json);
        }
        return result;
    }

}
