/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.timer;

import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"prod"})
public class SyncDeviceLostContactTimer {
    @Autowired
    private LogicService logicService;
    @Autowired
    private SqlService sqlService;
    private final Logger LOG_MANAGER = LogManager.getLogger(SyncDeviceLostContactTimer.class);

    @Scheduled(cron="0 1 19 * * ?")
    public void runDataSync() {
        this.LOG_MANAGER.info("=====\u5f00\u59cb\u6267\u884c\u540c\u6b65\u8bbe\u5907\u5931\u8054\u6570\u636e\u4efb\u52a1=====");
        try {
            int pageNo = 1;
            int pageSize = 200;
            while (true) {
                JSONArray resultArray = new JSONArray(this.sqlService.txExecute("getAllDeviceAndMeter", pageNo, pageSize, new JSONObject().put("data", (Object)new JSONObject().put("day", 3)).toString()));
                this.LOG_MANAGER.info("======\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\uff0c\u7b2c{}\u6279\u6b21\uff0c\u672c\u6279\u6b21\u5171{}\u6761=====", (Object)pageNo, (Object)resultArray.length());
                if (resultArray.isEmpty()) break;
                resultArray.forEach(item -> this.runLogic("deviceLostContact", (JSONObject)item));
                this.LOG_MANAGER.info("======\u7b2c{}\u6279\u6b21\u6267\u884c\u5b8c\u6210=====", (Object)(++pageNo));
            }
            this.LOG_MANAGER.info("\u5931\u8054\u8bbe\u5907\u6570\u636e\u540c\u6b65\u5b8c\u6210");
        }
        catch (Exception e) {
            this.LOG_MANAGER.error("\u5931\u8054\u8bbe\u5907\u6570\u636e\u540c\u6b65\u5931\u8d25", (Throwable)e);
        }
    }

    private void runLogic(String logicName, JSONObject data) {
        try {
            this.logicService.xtSave(logicName, data.toString());
        }
        catch (Exception ex) {
            this.LOG_MANAGER.error("Logic\u6267\u884c\u5931\u8d25", (Throwable)ex);
        }
    }
}

