/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.mapper;

import com.aote.redis.RedisUtil;
import com.aote.rs.SqlService;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlarmStrategyMapper {
    public static final String IS_LOADED_KEY = "ALARM_STRATEGY_IS_LOADED";
    public static final String NO_LOAD_FLAG = "0";
    public static final String LOADED_FLOG = "1";
    public static final String ALARM_STRATEGY_KEY = "IOT_SY";
    private static final Logger LOGGER = Logger.getLogger(AlarmStrategyMapper.class);
    private static final String QUERY_SQL = "SELECT * FROM t_iot_device_alarm_strategy WHERE f_state = 1 ORDER BY f_alarm_brand_id";
    private static final String DEVICE_BRAND_QUERY_SQL = "SELECT id, f_alias FROM t_iot_device_brand";
    @Autowired
    private SqlService sqlService;

    @PostConstruct
    public void load() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.syncLock(IS_LOADED_KEY, Integer.valueOf(300), () -> {
                Object isLoaded = redisUtil.get(IS_LOADED_KEY);
                if (isLoaded == null || NO_LOAD_FLAG.equals(isLoaded)) {
                    JSONArray result = null;
                    try {
                        result = new JSONArray(this.sqlService.txQuery(QUERY_SQL));
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"\u7269\u8054\u7f51\u544a\u8b66\u7b56\u7565(t_iot_device_alarm_strategy)\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u518d\u52a0\u8f7d\u544a\u8b66\u7b56\u7565\u914d\u7f6e");
                    }
                    if (result != null) {
                        HashMap<Integer, String> deviceBrandMap;
                        try {
                            JSONArray deviceBrandList = new JSONArray(this.sqlService.txQuery(DEVICE_BRAND_QUERY_SQL));
                            deviceBrandMap = new HashMap<Integer, String>(deviceBrandList.length());
                            for (Object item : deviceBrandList) {
                                JSONObject itemObj = (JSONObject)item;
                                deviceBrandMap.put(itemObj.getInt("id"), itemObj.getString("f_alias"));
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        JSONObject data = new JSONObject();
                        for (Object o : result) {
                            JSONArray valueArray;
                            JSONObject item = (JSONObject)o;
                            String alias = (String)deviceBrandMap.get(item.getInt("f_alarm_brand_id"));
                            if (data.has(alias)) {
                                valueArray = data.getJSONArray(alias);
                            } else {
                                valueArray = new JSONArray();
                                data.put(alias, (Object)valueArray);
                            }
                            valueArray.put((Object)item);
                        }
                        redisUtil.set(ALARM_STRATEGY_KEY, (Object)data);
                        redisUtil.set(IS_LOADED_KEY, (Object)LOADED_FLOG);
                        LOGGER.debug((Object)"\u7269\u8054\u7f51\u544a\u8b66\u7b56\u7565\u9884\u52a0\u8f7d\u5b8c\u6210");
                    }
                } else {
                    LOGGER.debug((Object)"\u8df3\u8fc7\u52a0\u8f7d\u7269\u8054\u7f51\u544a\u8b66\u7b56\u7565\u8868");
                }
            });
        }
    }

    public void clearCache() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.syncLock(IS_LOADED_KEY, Integer.valueOf(20), () -> redisUtil.set(IS_LOADED_KEY, (Object)NO_LOAD_FLAG));
            this.load();
        }
    }
}

