/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.enums;

import java.util.stream.Stream;

public enum DataSourceTypeEnum {
    SQLSERVER("SqlServer"),
    ORACLE("Oracle"),
    MYSQL("MySQL");

    private final String value;

    private DataSourceTypeEnum(String value) {
        this.value = value;
    }

    public static DataSourceTypeEnum toType(String value) {
        return Stream.of(DataSourceTypeEnum.values()).filter(p -> p.value.equalsIgnoreCase(value)).findAny().orElse(null);
    }

    public static boolean is(String value) {
        return DataSourceTypeEnum.toType(value) != null;
    }

    public String getValue() {
        return this.value;
    }
}

