package com.aote.webmeter.tools;

import com.aote.redis.RedisUtil;
import com.aote.rs.LogicService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

/**
 * 上报请求工具
 */
@Component
public class ReportTools {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = Logger.getLogger(ReportTools.class);
    private final RedisUtil redisUtil = RedisUtil.getInstance();
    @Autowired
    private LogicService logicService;

    /**
     * 执行业务（阻止重复请求）
     *
     * @param unique    唯一标识
     * @param value     业务数据
     * @param logicName 业务名称
     * @return 执行结果
     */
    public Object run(String unique, String value, String logicName) {
        AtomicReference<Object> result = new AtomicReference<>();
        try {
            redisUtil.lock(unique, 5, 30, () -> result.set(runLogic(logicName, value)));
        } catch (InterruptedException e) {
            //由于锁占用，业务降级处理
            result.set(runLogic(logicName + "LowerRank", value));
        } catch (Exception e) {
            LOGGER.error("【" + logicName + "】出现异常：", e);
            throw e;
        }
        return result.get();
    }

    private Object runLogic(String logicName, String data) {
        try {
            return logicService.xtSave(logicName, data);
        } catch (Exception e) {
            LOGGER.error("【" + logicName + "】出现异常：", e);
            throw e;
        }
    }
}
