package com.aote.rs;

import com.aote.util.ExceptionHelper;
import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.timer.WebMeterTimer;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.SignalDeliveryTools;
import com.aote.webmeter.tools.iot.ctwing.CTWingApiService;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import java.io.IOException;

/**
 * 物联网表控制器服务
 */
@Path("api")
@Component
public class WebMeterService {
    private static final Logger LOGGER = Logger.getLogger(WebMeterService.class);

    @Autowired
    private CTWingApiService ctWingApiService;

    /**
     * 重新加载物联网表模块参数（WebmeterInfo）
     *
     * @return 执行结果
     */
    @GET
    @Path("reloadProp")
    @Produces("text/plain;charset=UTF-8")
    public String reloadWebmeterInfo() {
        LOGGER.debug("重新加载物联网表模块参数");
        //获取物联网表配置文件并加载
        WebMeterInfo.clear();
        WebMeterInfo.load();
        return "命令已处理完成";
    }

    /**
     * 重新加载物联网表Timer指令业务列表（BUSINESS_LIST）
     *
     * @return 执行结果
     */
    @GET
    @Path("reloadTimer")
    @Produces("text/plain;charset=UTF-8")
    public String reloadTimer() {
        LOGGER.debug("重新加载物联网表Timer指令业务列表");
        //获取物联网表Timer指令业务列表并加载
        WebMeterTimer.clear();
        WebMeterTimer.load();
        return "命令已处理完成";
    }

    /**
     * 设置IOT平台订阅地址
     *
     * @return 执行结果
     */
    @POST
    @Path("setIotSubscriptions/{moduleName}")
    public Response setIotSubscriptions(@PathParam("moduleName") String moduleName, String values) throws IOException {
        LOGGER.debug("设置IOT平台订阅地址");
        try {
            WebMeterInfo.setModuleName(moduleName);
            JSONObject obj = new JSONObject(values);
            String url = obj.getString("url");
            IotCommonTools.setIsAep(obj.getInt("isAep"));
            ctWingApiService.deleteAllSubscribe();
            JSONObject result = ctWingApiService.subscribe(NotifyTypeEnum.DEVICE_DATAS_CHANGED, url);
            Response.ResponseBuilder builder = Response.ok();
            return builder.entity(result).build();
        } catch (Exception e) {
            String errorInfo = ExceptionHelper.stackToString(e);
            return Response.serverError().entity(errorInfo).build();
        }
    }
}
