-- 公共SQL：生成开户指令（适用V3，附带用户信息和充值信息）
-- 必选参数
-- f_meter_brand：表具品牌别名

SELECt
    -- 表档案ID
    u.f_userfiles_id        userid,
    -- 表档案编号
    u.f_user_id,
    -- 用户姓名
    o.f_user_name           f_user_name,
    -- 电话
    ISNULL(o.f_user_phone, '无电话') f_user_phone,
    -- 地址
    ISNULL(a.f_address, '无地址') f_address,
    -- 表号
    u.f_meternumber,
    -- 卡号
    ISNULL(u.f_card_id, u.f_meternumber)            f_card_id,
    -- 阶梯周期（月）
    ISNULL(s.f_stairmonths, 1)                      f_stairmonths,
    -- 阶梯开始时间
    ISNULL(s.f_stair_start_date, s.f_perform_date)  start_date,
    -- 气表型号
    m.f_meter_style                                 f_meter_style,
    -- 结算方式
    b.f_collection_type,
    -- 气价ID
    s.id                stairid,
    -- IMEI
    i.f_imei,
    -- IMSI
    i.f_imsi,
    -- 平台类型
    i.f_iot_type,
    -- 是否AEP模式
    i.f_terminal_id,
    -- 业务记录ID
    sell.id             sellid,
    -- 充值金额
    sell.payvalue,
    -- 充值气量
    sell.paygasvalue,
    -- 充值次数
    sell.f_times,
    -- 总购金额
    sell.total,
    -- 总购气量
    sell.totalgas,
    -- 充值类型
    sell.type           type
FROM (
         SELECT f.id             id,
                f.f_userfiles_id userid,
                f.f_preamount    payvalue,
                f.f_pregas       paygasvalue,
                f.f_times        f_times,
                f.id             f_old_sell_id,
                f.f_total_fee    total,
                f.f_total_gas    totalgas,
                '换表补气'        type
         FROM t_fillgas f
         WHERE f.f_state = '有效'
           AND f.f_times = '1'
           AND (f.f_sendsuccess = '未同步' or f.f_sendsuccess IS NULL)
         UNION ALL
         SELECT s.id             id,
                s.f_userfiles_id userid,
                case s.f_type
                    when '退费' then s.f_collection
                    else s.f_preamount
                    end          payvalue,
                s.f_pregas       paygasvalue,
                s.f_times        f_times,
                s.f_old_sell_id,
                s.f_total_fee    total,
                s.f_total_gas    totalgas,
                '充值'            type
         FROM t_sellinggas s
         WHERE s.f_state = '有效'
           AND s.f_times = '1'
           AND s.f_type = '物联网收费'
           AND (s.f_sendsuccess = '未同步' or s.f_sendsuccess IS NULL)
     ) sell
         LEFT JOIN t_userfiles u ON u.f_userfiles_id = sell.userid
         LEFT JOIN t_meterinfo i ON i.f_meternumber = u.f_meternumber
         LEFT JOIN t_userinfo o ON o.f_userinfo_id = u.f_userinfo_id
         LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
         LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
         LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id and u.f_filialeid = s.f_filialeid
         LEFT JOIN t_user_address a ON o.f_userinfo_id = a.f_userinfo_id
WHERE (u.f_sendsuccess = '未同步' or u.f_sendsuccess IS NULL)
  AND u.f_table_state = '正常'
  AND u.f_gasbrand_id IN (${gasBrandIds})
  AND o.f_user_state = '正常'
  AND s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  AND getdate() <= s.f_end_date
