-- 公共SQL：生成注销/换表指令（适用V3，附带NB平台信息）
-- 必选参数
-- f_meter_brand：表具品牌别名

SELECT
    -- 业务记录ID
    t_changetables.id,
    -- 表档案编号
    t_changetables.f_user_id,
    -- 新表档案ID
    t_changetables.f_userfiles_id,
    t_changetables.f_userfiles_id userId,
    -- 旧表档案ID
    t_changetables.f_userfiles_id_old,
    -- 用户编号
    t_changetables.f_userinfo_id,
    -- 旧表厂家
    t_gasbrand.f_manufacturers,
    -- 旧表表号
    t_changetables.f_meternumber_old f_meternumber,
    -- 新表表号
    t_changetables.f_meternumber     f_newmeternumber,
    -- 旧表气表品牌名称
    t_gasbrand.f_meter_brand,
    -- 平台设备号
    m.f_device_id,
    -- 平台类型
    m.f_iot_type,
    -- imei
    m.f_imei,
    -- 是否AEP模式
    m.f_terminal_id,
    -- 组织机构信息
    tu.f_filialeid,
    tu.f_orgid,
    tu.f_depid,
    tu.f_orgname,
    tu.f_depname
FROM t_changetables
         LEFT JOIN t_userfiles tu ON t_changetables.f_userfiles_id_old = tu.f_userfiles_id
         LEFT JOIN t_meterinfo m ON t_changetables.f_meternumber_old = m.f_meternumber
         LEFT JOIN t_gasbrand ON t_changetables.f_gasbrand_id_old = t_gasbrand.id
WHERE (t_changetables.f_sendsuccess = '未同步' or t_changetables.f_sendsuccess is null)
  AND t_changetables.f_type = '换新表'
  AND tu.f_sendsuccess IN ('成功','待执行')
  AND m.f_imei IS NOT NULL
  AND m.f_iot_type IS NOT NULL
  AND t_changetables.f_gasbrand_id_old IN (${gasBrandIds})
