/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.ctwing;

import com.af.expression.exception.ServiceException;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.HttpDeleteWithBody;
import com.aote.redis.RedisService;
import com.aote.redis.RedisUtil;
import com.aote.webmeter.enums.CTWingPlatformType;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.ctwing.CTWingApi;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CTWingApiService {
    public static final String ERROR_PARAMS_KEY = "error_code";
    public static final String ERROR_PARAMS_KEY_2 = "resultcode";
    private static final ThreadLocal<CTWingPlatformType> PLATFORM_TYPE_THREAD_LOCAL = new ThreadLocal();
    private static final String SELF_CERT_PWD = "IoM@1234";
    private static final String TRUST_CA_PWD = "Huawei@123";
    private static final String CTWing_API_TOKEN_CACHE_KEY = "ctwingApiToken@";
    private static final String CTWing_API_REFRESH_TOKEN_CACHE_KEY = "ctwingApiRefreshToken@";
    private static final String AUTH_ERROR = "1010005";
    private static final String DEVICE_BINDED_1 = "100416";
    private static final String DEVICE_BINDED_2 = "100426";
    private static final String DEVICE_BINDED_3 = "1104";
    private static final String DEVICE_CANCEL_BINDED_1 = "100403";
    private static final String DEVICE_CANCEL_BINDED_2 = "100418";
    private static final Logger LOGGER = LoggerFactory.getLogger(CTWingApiService.class);
    private static volatile CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CloseableHttpClient getHttpClient() {
        if (httpClient != null) return httpClient;
        Class<CTWingApiService> clazz = CTWingApiService.class;
        synchronized (CTWingApiService.class) {
            if (httpClient != null) return httpClient;
            httpClient = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)CTWingApiService.initSslConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    private static String getCTWingApiTokenRedisKey(String appid) {
        return CTWing_API_TOKEN_CACHE_KEY + appid;
    }

    private static String getCTWingApiRefreshTokenRedisKey(String appid) {
        return CTWing_API_REFRESH_TOKEN_CACHE_KEY + appid;
    }

    /*
     * Exception decompiling
     */
    private static SSLConnectionSocketFactory initSslConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CTWingPlatformType getPlatformType() {
        return PLATFORM_TYPE_THREAD_LOCAL.get();
    }

    public static void setPlatformType(CTWingPlatformType type) {
        PLATFORM_TYPE_THREAD_LOCAL.set(type);
    }

    public static void setPlatformType(String typeStr) {
        PLATFORM_TYPE_THREAD_LOCAL.set(CTWingPlatformType.toType(Integer.valueOf(typeStr)));
    }

    private String requestGetToken(String appid, String secret) {
        RedisUtil redisService = RedisUtil.getInstance();
        JSONObject content = new JSONObject();
        content.put("appId", (Object)appid);
        content.put("secret", (Object)secret);
        String refreshTokenKey = CTWingApiService.getCTWingApiRefreshTokenRedisKey(appid);
        Object refreshToken = redisService.get(refreshTokenKey);
        if (refreshToken != null) {
            content.put("refreshToken", refreshToken);
            JSONObject result = this.post(IOTBusinessTypeEnum.REFRESH_AUTH, content, null);
            if (result.has("msg")) {
                redisService.delete(refreshTokenKey);
                return this.requestGetToken(appid, secret);
            }
            String newAccessToken = result.getString("accessToken");
            String newRefreshToken = result.getString("refreshToken");
            redisService.set(CTWingApiService.getCTWingApiTokenRedisKey(appid), (Object)newAccessToken, (long)(result.getInt("expiresIn") - 60));
            if (!refreshToken.equals(newRefreshToken)) {
                redisService.set(refreshTokenKey, (Object)newRefreshToken, 86340L);
            }
            return newAccessToken;
        }
        JSONObject result = this.post(IOTBusinessTypeEnum.AUTH, content, null);
        if (result.has("msg")) {
            Object data = result.opt("data");
            String msg = data != null ? new JSONObject(data.toString()).optString("error_desc") : result.optString("msg", null);
            throw new ServiceException("\u5929\u7ffcNB-IOT\u5e73\u53f0\u9274\u6743\u5931\u8d25, appId: " + appid + ", error: " + msg);
        }
        String newRefreshToken = result.getString("refreshToken");
        redisService.set(refreshTokenKey, (Object)newRefreshToken, 86340L);
        return this.requestGetToken(appid, secret);
    }

    private String getTokenLastAttemptTimeCacheKey(String appId) {
        return "ctwingApiToken@LastAttemptTime" + appId;
    }

    private String getAuthToken(String appid, String secret, boolean force) {
        String tokenCache;
        RedisUtil redisService = RedisUtil.getInstance();
        String key = CTWingApiService.getCTWingApiTokenRedisKey(appid);
        Supplier<String> getTokenByCache = () -> CTWingApiService.lambda$getAuthToken$0((RedisService)redisService, key, appid);
        if (!force && (tokenCache = getTokenByCache.get()) != null) {
            return tokenCache;
        }
        String[] resultToken = new String[]{null};
        try {
            redisService.lock(key, () -> this.lambda$getAuthToken$1(force, getTokenByCache, resultToken, appid, (RedisService)redisService, secret));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return resultToken[0];
    }

    private String getAuthToken(String appid, String secret) {
        return this.getAuthToken(appid, secret, false);
    }

    public JSONObject sendInstruct(String serviceId, String method, String deviceId, Object jo) {
        CTWingPlatformType platformType = CTWingApiService.getPlatformType();
        if (jo instanceof String) {
            JSONObject object = new JSONObject();
            object.put("rawData", (Object)jo.toString());
            jo = object;
            if (platformType != CTWingPlatformType.AEP || serviceId == null) {
                serviceId = "RawData";
            }
        }
        String callbackUrl = platformType == CTWingPlatformType.AEP ? WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_CALLBACK_URL.getValue()) : (platformType == CTWingPlatformType.OC ? WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_CALLBACK_URL.getValue()) : WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_CALLBACK_URL.getValue()));
        Integer maxRetransmit = 3;
        JSONObject paramCommand = new JSONObject();
        paramCommand.put("serviceId", (Object)serviceId);
        paramCommand.put("method", (Object)method);
        paramCommand.put("paras", jo);
        JSONObject content = new JSONObject();
        content.put("deviceId", (Object)deviceId);
        content.put("command", (Object)paramCommand);
        content.put("callbackUrl", (Object)callbackUrl);
        content.put("expireTime", 0);
        content.put("maxRetransmit", (Object)maxRetransmit);
        JSONObject response = this.post(IOTBusinessTypeEnum.SEND_COMMAND, content, null);
        JSONObject result = new JSONObject();
        if (response.has("msg")) {
            result.put("code", -1).put("msg", response.get("msg"));
        } else {
            result.put("code", 0).put("commandId", response.get("commandId"));
        }
        return result;
    }

    public JSONObject subscribe(NotifyTypeEnum notifyTypeEnum, String callBackUrl) {
        JSONObject content = new JSONObject();
        content.put("notifyType", (Object)notifyTypeEnum.getValue());
        content.put("callbackUrl", (Object)callBackUrl);
        JSONObject result = this.post(IOTBusinessTypeEnum.SUBSCRIPTIONS, content, null);
        if (result.has("msg")) {
            LOGGER.error("IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a{}", (Object)result);
            return null;
        }
        return result;
    }

    public JSONObject deleteAllSubscribe() {
        JSONObject result = this.post(IOTBusinessTypeEnum.DELETE_ALL_SUBSCRIPTIONS, null, null);
        if (result.has("msg")) {
            LOGGER.error("IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a{}", (Object)result);
            return null;
        }
        return result;
    }

    public JSONObject regDevice(String nodeId, String name) throws IOException {
        JSONObject content = new JSONObject();
        content.put("nodeId", (Object)nodeId);
        content.put("verifyCode", (Object)nodeId);
        content.put("timeout", 0);
        content.put("deviceName", (Object)name);
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("manufacturerId", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.MANUFACTURER_ID));
        deviceInfo.put("manufacturerName", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.MANUFACTURER_NAME));
        deviceInfo.put("deviceType", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.DEVICE_TYPE));
        deviceInfo.put("model", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.METER_MODEL));
        deviceInfo.put("protocolType", (Object)"CoAP");
        content.put("deviceInfo", (Object)deviceInfo);
        JSONObject result = new JSONObject();
        JSONObject resultData = this.post(IOTBusinessTypeEnum.CREATE_DEVICE, content);
        if (resultData.has("msg")) {
            JSONObject errorEntity = new JSONObject(resultData.get("data").toString());
            String errorKey = errorEntity.get(ERROR_PARAMS_KEY).toString();
            if (DEVICE_BINDED_1.equals(errorKey) || DEVICE_BINDED_2.equals(errorKey) || DEVICE_BINDED_3.equals(errorKey)) {
                result.put("code", -1).put("msg", (Object)"\u5c1d\u8bd5\u6ce8\u518c\u65f6\u5df2\u7ed1\u5b9a");
            } else {
                result.put("code", -1).put("msg", (Object)("\u6ce8\u518cIOT\u8bbe\u5907\u5931\u8d25\uff1a" + errorEntity));
            }
        } else {
            result.put("code", 0).put("msg", (Object)resultData.getString("deviceId"));
        }
        return result;
    }

    public JSONObject removeDevice(String deviceId) {
        JSONObject result = new JSONObject();
        JSONObject resultData = this.post(IOTBusinessTypeEnum.REMOVE_DEVICE, null, deviceId);
        if (resultData.has("msg")) {
            JSONObject errorEntity = new JSONObject(resultData.get("data").toString());
            String code = errorEntity.get(ERROR_PARAMS_KEY).toString();
            if (DEVICE_CANCEL_BINDED_1.equals(code) || DEVICE_CANCEL_BINDED_2.equals(code)) {
                result.put("code", 0).put("msg", (Object)"\u5c1d\u8bd5\u5220\u9664\u65f6\u5df2\u4e0d\u5b58\u5728");
            } else {
                result.put("code", -1).put("msg", (Object)("\u5220\u9664IOT\u8bbe\u5907\u5931\u8d25\uff1a" + errorEntity));
            }
        } else {
            result.put("code", 0).put("msg", (Object)"\u6210\u529f");
        }
        return result;
    }

    private JSONObject post(IOTBusinessTypeEnum typeEnum, JSONObject contentObj) {
        return this.post(typeEnum, contentObj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject post(IOTBusinessTypeEnum typeEnum, JSONObject contentObj, String urlAppend) {
        JSONObject result;
        String secret;
        String appid;
        CTWingPlatformType platformType = CTWingApiService.getPlatformType();
        if (platformType == CTWingPlatformType.AEP) {
            appid = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_APIKEY);
            secret = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_SECRET);
        } else if (platformType == CTWingPlatformType.OC) {
            appid = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_APIKEY);
            secret = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_SECRET);
        } else {
            appid = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_APIKEY);
            secret = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_SECRET);
        }
        String header = null;
        if (typeEnum != IOTBusinessTypeEnum.AUTH) {
            JSONObject headerObj = new JSONObject();
            if (typeEnum != IOTBusinessTypeEnum.REFRESH_AUTH) {
                String accessToken = this.getAuthToken(appid, secret);
                headerObj.put("app_key", (Object)appid);
                headerObj.put("Authorization", (Object)("Bearer " + accessToken));
            }
            headerObj.put("Content-Type", (Object)"application/json");
            header = headerObj.toString();
        }
        String url = null;
        HttpPost request = null;
        switch (typeEnum) {
            case AUTH: {
                url = CTWingApi.getAuthUrl();
                request = new HttpPost();
                break;
            }
            case REFRESH_AUTH: {
                url = CTWingApi.getRefreshAuthUrl();
                request = new HttpPost();
                break;
            }
            case CREATE_DEVICE: {
                url = CTWingApi.getDeviceCreateUrl();
                request = new HttpPost();
                break;
            }
            case MODIFY_DEVICE: {
                url = CTWingApi.getDeviceUpdateUrl() + "/" + urlAppend;
                request = new HttpPost();
                break;
            }
            case REMOVE_DEVICE: {
                url = CTWingApi.getDeviceUpdateUrl() + "/" + urlAppend;
                request = new HttpDeleteWithBody();
                break;
            }
            case SEND_COMMAND: {
                url = CTWingApi.getSendInstructUrl();
                request = new HttpPost();
                break;
            }
            case SUBSCRIPTIONS: {
                url = CTWingApi.getSubscriptionsUrl();
                request = new HttpPost();
                break;
            }
            case DELETE_ALL_SUBSCRIPTIONS: {
                url = CTWingApi.getSubscriptionsUrl();
                request = new HttpDeleteWithBody();
            }
        }
        CloseableHttpClient client = url.startsWith("https") ? CTWingApiService.getHttpClient() : HttpConnectionPoolUtil.getHttpClient();
        if (contentObj == null) {
            contentObj = new JSONObject();
        }
        String log = "api: " + url + "\uff0cheader: " + header + "\uff0cbody: " + contentObj;
        try {
            String responseBody = typeEnum == IOTBusinessTypeEnum.AUTH ? HttpConnectionPoolUtil.requestFormUrlEncoded((String)url, (JSONObject)contentObj, (HttpEntityEnclosingRequestBase)request, (CloseableHttpClient)client) : HttpConnectionPoolUtil.request((String)url, (String)contentObj.toString(), (String)header, (HttpRequestBase)request, (CloseableHttpClient)client);
            log = log + "\uff0cresponse: " + responseBody;
            if (responseBody == null) {
                JSONObject jSONObject = new JSONObject();
                return jSONObject;
            }
            result = new JSONObject(responseBody);
            if (result.has("errorEntity")) {
                result.put("msg", (Object)"error");
                result.put("data", result.get("errorEntity"));
            }
        }
        catch (IOException e) {
            result = new JSONObject();
            result.put("msg", (Object)e.getMessage());
            log = log + "\uff0cresponse: " + e.getMessage();
        }
        finally {
            LOGGER.info(log);
        }
        if (typeEnum != IOTBusinessTypeEnum.AUTH && typeEnum != IOTBusinessTypeEnum.REFRESH_AUTH && result.has("msg")) {
            if (result.has("data")) {
                String auth;
                String entity = result.get("data").toString();
                JSONObject errorEntity = new JSONObject(entity);
                String code = errorEntity.has(ERROR_PARAMS_KEY) ? errorEntity.get(ERROR_PARAMS_KEY).toString() : errorEntity.get(ERROR_PARAMS_KEY_2).toString();
                if (AUTH_ERROR.equals(code) && (auth = this.getAuthToken(appid, secret, true)) != null) {
                    return this.post(typeEnum, contentObj, urlAppend);
                }
            } else {
                result.put("code", -1).put("msg", (Object)result.getString("msg"));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$getAuthToken$1(boolean force, Supplier getTokenByCache, String[] resultToken, String appid, RedisService redisService, String secret) {
        long last;
        String tokenCache;
        long now = System.currentTimeMillis();
        if (!force && (tokenCache = (String)getTokenByCache.get()) != null) {
            resultToken[0] = tokenCache;
            return;
        }
        String timeKey = this.getTokenLastAttemptTimeCacheKey(appid);
        Object lastTime = redisService.get(timeKey);
        long l = last = lastTime == null ? 0L : Long.parseLong(lastTime.toString());
        if (now - last < 120000L) {
            String tokenCache2 = (String)getTokenByCache.get();
            if (tokenCache2 != null) {
                resultToken[0] = tokenCache2;
                return;
            }
            throw new RuntimeException(appid + ": \u6ca1\u6709\u5f97\u5230\u4efb\u4f55\u7684Token\uff0c\u4e14\u5904\u4e8e\u9274\u6743\u51b7\u5374\u671f\uff0c\u7b49\u5f852\u5206\u949f");
        }
        LOGGER.info("\u5929\u7ffcNB-IOT\u5e73\u53f0\uff1a{}\u8fdb\u884c\u9274\u6743\u64cd\u4f5c", (Object)appid);
        try {
            String newToken;
            resultToken[0] = newToken = this.requestGetToken(appid, secret);
        }
        finally {
            redisService.set(timeKey, (Object)String.valueOf(System.currentTimeMillis()), 300L);
        }
    }

    private static /* synthetic */ String lambda$getAuthToken$0(RedisService redisService, String key, String appid) {
        Object cachedToken = redisService.get(key);
        if (cachedToken != null) {
            LOGGER.info("{}:\u83b7\u53d6\u7f13\u5b58 token", (Object)appid);
            return cachedToken.toString();
        }
        return null;
    }
}

