/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.timer;

import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class InstructSyncTimerMain {
    private static final Logger LOG_MANAGER = LogManager.getLogger(InstructSyncTimerMain.class);
    @Autowired
    private SqlServer sqlServer;

    public void run(DataSourceTypeEnum dataSourceTypeEnum, String instructTableName, String topSQL) throws Exception {
        if (dataSourceTypeEnum == DataSourceTypeEnum.ORACLE) {
            this.sqlServer.runSQL("TRUNCATE TABLE temp_history_instruct");
            this.sqlServer.runSQL(String.format("INSERT INTO temp_history_instruct SELECT * FROM ( %s ) a", topSQL));
            this.sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM temp_history_instruct");
            this.sqlServer.runSQL("DELETE FROM " + instructTableName + " t WHERE exists (SELECT 1 FROM temp_history_instruct h where h.id = t.id)");
        } else if (dataSourceTypeEnum == DataSourceTypeEnum.SQLSERVER) {
            this.sqlServer.runSQL(String.format("IF OBJECT_ID('tempdb..##temp_history_instruct', 'U') IS NOT NULL DROP TABLE ##temp_history_instruct;\nSELECT * INTO ##temp_history_instruct FROM ( %s ) a;\nINSERT INTO t_instruct_history SELECT * FROM ##temp_history_instruct;\nDELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM ##temp_history_instruct);", topSQL));
        } else {
            this.sqlServer.runSQL("execMigrationInstruct", new Object[]{String.format("DROP TEMPORARY TABLE IF EXISTS temp_history_instruct;\nCREATE TEMPORARY TABLE temp_history_instruct %s;\nINSERT INTO t_instruct_history SELECT * FROM temp_history_instruct;\nDELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM temp_history_instruct);", topSQL)});
        }
    }
}

