package com.aote.webmeter.tools.iot.onenet;

import lombok.SneakyThrows;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * 老版移动Onenet-IOT平台 API调用工具
 * 请使用新版 OnenetApiService
 * @author Mr.river
 */
@Component
@Deprecated
public class OnenetRestTools {
    private static final Logger LOGGER = Logger.getLogger(OnenetRestTools.class);

    @Autowired
    private OnenetApiService onenetApiService;

    /**
     * 写入设备资源
     * @param imei 设备imei
     * @param mode 写入模式（1或2）
     * @param timeout 超时时间，默认25秒
     * @param content 请求内容(实际请求参数)
     * @return 响应结果
     */
    @SneakyThrows
    public JSONObject writeDeviceRes(String imei, String mode, String timeout, JSONObject content) throws IOException {
        return onenetApiService.writeDeviceRes(imei, mode, timeout,
                content.getJSONArray("data").getJSONObject(0).getString("val"));
    }

    /**
     * 命令下发
     * @param imei 设备imei
     * @param timeout 超时时间，默认25秒
     * @param content 请求内容(实际请求参数)
     * @return 响应结果
     */
    @SneakyThrows
    public JSONObject sendCommand(String imei, String timeout, JSONObject content) {
        return onenetApiService.sendCommand(imei, timeout, content.getString("args"));
    }

    /**
     * 订阅
     *
     * @param params 请求参数
     * @return 响应结果
     */
    @SneakyThrows
    public JSONObject subscribe(JSONObject params) {
        return onenetApiService.subscribe(params);
    }
}
