package com.aote.webmeter.tools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author 张琪
 * @date 2022/8/25 10:01
 */
public class ByteTool {
    private static final Logger log = LoggerFactory.getLogger(ByteTool.class);


    /**
     * 16进制字符串 ---> 字节数组
     * @param src
     * @return
     */
    public static byte[] hexString2Bytes(String src) {
        int l = src.length() / 2;
        byte[] ret = new byte[l];
        for (int i = 0; i < l; i++) {
            ret[i] = Integer
                    .valueOf(src.substring(i * 2, i * 2 + 2), 16).byteValue();
        }
        return ret;
    }


    /**
     * 字节数组转 16进制字符串
     * @param bArr
     * @return
     */
    public static String bytesToHexString(byte[] bArr) {
        if (bArr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(bArr.length);
        String sTmp;

        for (int i = 0; i < bArr.length; i++) {
            sTmp = Integer.toHexString(0xFF & bArr[i]);

            if (sTmp.length() < 2)
                sb.append(0);
            sb.append(sTmp.toUpperCase());
        }

        return sb.toString();
    }

    /**
     * 数组反转
     * @param list 带反转数组
     * @return 反转后数组
     */
    public static byte[] reserve(byte[] list) {
        int start = 0;
        int end = list.length - 1;

        while (start < end) {
            byte temp = list[start];
            list[start] = list[end];
            list[end] = temp;
            start++;
            end--;
        }
        return list;
    }


}
