package com.aote.webmeter.socket.config;

import com.af.plugins.JsonTools;
import com.aote.webmeter.socket.enums.SocketTypeEnum;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * socket配置
 *
 * @author Mr.river
 */
public class SocketConfig {

    /**
     * Socket服务端列表
     */
    private static final List<SocketConfigItem> socketConfigItemList = new ArrayList<>();

    static {
        try (InputStream inputStream = SocketConfig.class.getClassLoader().getResourceAsStream("config/server/TCPListenerConfig.json")) {
            if (inputStream != null) {
                JSONArray array = JsonTools.readJsonArrayFile("config/server/TCPListenerConfig.json");
                array.forEach((item) -> {
                    JSONObject params = (JSONObject) item;
                    setSocketConfigItem(params, SocketTypeEnum.TCP);
                });
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (InputStream inputStream = SocketConfig.class.getClassLoader().getResourceAsStream("config/server/UDPListenerConfig.json")) {
            if (inputStream != null) {
                JSONArray array = JsonTools.readJsonArrayFile("config/server/UDPListenerConfig.json");
                array.forEach((item) -> {
                    JSONObject params = (JSONObject) item;
                    setSocketConfigItem(params, SocketTypeEnum.UDP);
                });
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<SocketConfigItem> getSocketServerList() {
        return socketConfigItemList;
    }

    public static void setSocketConfigItem(JSONObject params, SocketTypeEnum typeEnum) {
        String name = params.getString("name");
        String logicName = params.getString("callBackName");
        JSONArray ports = params.getJSONArray("port");
        String msgReceiveType = params.getString("msgReceiveType");
        String msgSendType = params.getString("msgSendType");
        String channelDataName = params.optString("getChannelDataName", null);

        SocketConfigItem socketConfigItem = new SocketConfigItem();
        socketConfigItem.setName(name);
        socketConfigItem.setType(typeEnum.getValue());
        socketConfigItem.setPort(ports.toList());
        socketConfigItem.setDecodeType(msgReceiveType);
        socketConfigItem.setEncodeType(msgSendType);
        socketConfigItem.setLogicName(logicName);
        socketConfigItemList.add(socketConfigItem);
    }
}
