package com.aote.webmeter.socket;

import com.aote.webmeter.socket.config.SocketConfig;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.server.SocketServer;
import com.aote.webmeter.socket.core.server.tcp.TcpServer;
import com.aote.webmeter.socket.core.server.udp.UdpServer;
import com.aote.webmeter.socket.enums.SocketTypeEnum;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class SocketServerManager implements ApplicationContextAware {

    public static ApplicationContext applicationContext;

    private static final Map<String, SocketConfigItem> socketConfigMap = new HashMap<>();
    private final List<SocketServer<?, ?>> socketServerList = new ArrayList<>();

    public static SocketConfigItem getSocketConfigItemByPort(String port) {
        return socketConfigMap.get(port);
    }

    /**
     * 启动socket服务端
     */
    @PostConstruct
    public void startAll() {
        List<SocketConfigItem> socketConfigItemList = SocketConfig.getSocketServerList();
        if (socketConfigItemList != null) {
            socketConfigItemList.forEach(item -> {
                SocketServer<?, ?> socketServer = createSocketServer(item);
                socketServerList.add(socketServer);
                item.getPort().forEach(port -> socketConfigMap.put(port.toString(), item));
                if (socketServer != null) {
                    socketServer.run(item);
                }
            });
        }
    }

    /**
     * 创建SocketServer实例
     */
    private SocketServer<?, ?> createSocketServer(SocketConfigItem item) {
        SocketServer<?, ?> socketServer = null;
        if (item.getType() == SocketTypeEnum.TCP) {
            socketServer = new TcpServer();
        } else if (item.getType() == SocketTypeEnum.UDP) {
            socketServer = new UdpServer();
        }
        return socketServer;
    }


    @PreDestroy
    public void destroyAll() {
        for (SocketServer<?, ?> socketServer : socketServerList) {
            socketServer.destroy();
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext atx) throws BeansException {
        applicationContext = atx;
    }
}
