package com.aote.webmeter.server.udp;

import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import com.aote.webmeter.server.tcp.TcpListener;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.util.ArrayList;
import java.util.List;

/**
 * UDP服务监听器
 *
 * @author Mrriver
 * @date 2019/2/11
 */
@Deprecated
public class UdpListener implements ServletContextListener {
    /**
     * 配置文件路径
     */
    private static final String PATH = "config/server/UDPListenerConfig.json";
    private List<UdpServer> udpServers;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        //读取Udp配置文件
        if (TcpListener.class.getClassLoader().getResourceAsStream(PATH) != null) {
            JSONArray array = JsonTools.readJsonArrayFile(PATH);
            udpServers = new ArrayList<>();
            array.forEach(item -> {
                JSONObject params = (JSONObject) item;
                //读取UDP服务名
                String name = params.getString("name");
                //读取Logic名
                String logicName = params.getString("callBackName");
                //读取Udp端口信息
                JSONArray ports = params.getJSONArray("udpPort");
                LogicServer service = WebApplicationContextUtils.
                        getWebApplicationContext(sce.getServletContext()).getBean(LogicServer.class);
                //读取UDP接收消息格式
                String msgReceiveType = params.getString("msgReceiveType");
                //读取UDP发送消息格式
                String msgSendType = params.getString("msgSendType");
                for (int i = 0; i < ports.length(); i++) {
                    UdpServer udpServer = new UdpServer(
                            name,
                            logicName,
                            ports.getInt(i),
                            service,
                            MsgTypeEnum.toType(msgReceiveType),
                            MsgTypeEnum.toType(msgSendType)
                    );
                    //放入Udp服务器数组
                    udpServers.add(udpServer);
                }
            });
        }
        for (UdpServer udpServer : udpServers) {
            //启动UdpServer
            udpServer.start();
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        for (UdpServer udpServer : udpServers) {
            if (udpServer != null && udpServer.isInterrupted()) {
                //销毁UdpServer
                udpServer.interrupt();
            }
        }
    }
}
