package com.aote.webmeter.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.StringJoiner;

/**
 * 物联网抄表表(t_meteread); 用于存储物联网表表段上送的数据
 * @author 张琪
 * @date 2022/9/27 17:38
 */
public class MeterRead {

    /**
     * 表底数 - 必填
     */
    @JsonProperty("f_tablebase")
    private BigDecimal tableBase;

    /**
     * 表余额
     */
    @JsonProperty("f_jval")
    private BigDecimal meterBalance;

    /**
     * 表单价
     */
    @JsonProperty("f_price")
    private BigDecimal meterPrice;

    /**
     * 充值次数
     */
    @JsonProperty("f_times")
    private Integer rechargeTimes;

    /**
     * 插电 - 内部电压
     */
    @JsonProperty("f_batteryLevel")
    private String voltage;

    /**
     * 安装电池- 内部电压
     */
    @JsonProperty("f_batteryLevel2")
    private String batteryVoltage;

    /**
     * 信号强度
     */
    @JsonProperty("f_signal")
    private String signalStrength;

    /**
     * 电量等级
     */
    @JsonProperty("f_electricity")
    private String powerLevel;

    /**
     * 阀门状态 0开，1关
     */
    @JsonProperty("f_valveState")
    private String valveState;

    /**
     * 磁干扰异常
     */
    @JsonProperty("f_magneticInterference")
    private String magneticInterference;

    /**
     * 外电低电状态
     */
    @JsonProperty("f_LowLithiumBattery")
    private String lowLithiumBattery;

    /**
     * 外电掉电状态
     */
    @JsonProperty("f_LostLithiumBattery")
    private String lostLithiumBattery;
    /**
     * 内电低电状态
     */
    @JsonProperty("f_LowLithiumBattery2")
    private String inLowLithiumBattery;
    /**
     * 表内累计充值金额
     */
    @JsonProperty("f_meterDebitAmt")
    private String meterDebitAmt;
    /**
     * 上报类型
     */
    @JsonProperty("f_upload_type")
    private String uploadType;

    /**
     * 阀门强制状态
     */
    @JsonProperty("f_networkShutValve")
    private String networkShutValve;

    /**
     * 信噪比
     */
    @JsonProperty("f_snr")
    private String snr;
    /**
     * 计量类型
     */
    @JsonProperty("f_wmprepaytype")
    private String measurementType;
    /**
     * 工况流量
     */
    @JsonProperty("operatingModeFlow")
    private String operatingModeFlow;

    /**
     * 标况流量
     */
    @JsonProperty("standardConditionFlow")
    private String standardConditionFlow;
    /**
     * 工况流速
     */
    @JsonProperty("factoryCurrentSpeed")
    private String factoryCurrentSpeed;
    /**
     * 标况流速
     */
    @JsonProperty("standardCurrentSpeed")
    private String standardCurrentSpeed;
    /**
     * 工况总量
     */
    @JsonProperty("operatingModeTotal")
    private String operatingModeTotal;
    /**
     * 标况总量
     */
    @JsonProperty("standardConditionTotal")
    private String standardConditionTotal;

    /**
     * 关阀走气
     */
    @JsonProperty("f_leakageFlag")
    private String leakageFlag;
    /**
     * 燃气泄露
     */
    @JsonProperty("f_gas_leakage")
    private String gasLeakage;
    /**
     * 流量异常
     */
    @JsonProperty("f_abnormal_flow")
    private String abnormalFlow;
    /**
     * 是否倾斜
     */
    @JsonProperty("f_is_tilt")
    private String isTilt;
    /**
     * 脉冲断线
     */
    @JsonProperty("f_pulse_disconnection")
    private String pulseDisconnection;
    /**
     * 干簧管异常
     */
    @JsonProperty("f_reed_switch_exception")
    private String reedSwitchException;
    /**
     * 采样-时钟异常
     */
    @JsonProperty("f_timesException")
    private String timesException;
    /**
     * 欠量标志
     */
    @JsonProperty("f_LackOfGasFlag")
    private String lackOfGasFlag;
    /**
     * 拆表报警
     */
    @JsonProperty("f_SplitAlarm")
    private String splitAlarm;
    /**
     * 外部报警
     */
    @JsonProperty("externalAlarm")
    private String externalAlarm;
    /**
     * 拆表时间
     */
    @JsonProperty("f_SplitAlarmDate")
    private String splitAlarmDate;
    /**
     * 外部晶振停止标志
     */
    @JsonProperty("f_XTIpllStopFlag")
    private String XTIpllStopFlag;
    /**
     * 死表标识
     */
    @JsonProperty("f_die_meter")
    private String dieMeter;
    /**
     * 死表标识2
     */
    @JsonProperty("f_die_meter_2")
    private String dieMeter2;
    /**
     * 阀门异常
     */
    @JsonProperty("f_valve_exception")
    private String valveException;


    public BigDecimal getTableBase() {
        return tableBase;
    }

    public void setTableBase(BigDecimal tableBase) {
        this.tableBase = tableBase;
    }

    public BigDecimal getMeterBalance() {
        return meterBalance;
    }

    public void setMeterBalance(BigDecimal meterBalance) {
        this.meterBalance = meterBalance;
    }

    public BigDecimal getMeterPrice() {
        return meterPrice;
    }

    public void setMeterPrice(BigDecimal meterPrice) {
        this.meterPrice = meterPrice;
    }

    public Integer getRechargeTimes() {
        return rechargeTimes;
    }

    public void setRechargeTimes(Integer rechargeTimes) {
        this.rechargeTimes = rechargeTimes;
    }

    public String getVoltage() {
        return voltage;
    }

    public void setVoltage(String voltage) {
        this.voltage = voltage;
    }

    public String getBatteryVoltage() {
        return batteryVoltage;
    }

    public void setBatteryVoltage(String batteryVoltage) {
        this.batteryVoltage = batteryVoltage;
    }

    public String getSignalStrength() {
        return signalStrength;
    }

    public void setSignalStrength(String signalStrength) {
        this.signalStrength = signalStrength;
    }

    public String getPowerLevel() {
        return powerLevel;
    }

    public void setPowerLevel(String powerLevel) {
        this.powerLevel = powerLevel;
    }

    public String getValveState() {
        return valveState;
    }

    public void setValveState(String valveState) {
        this.valveState = valveState;
    }

    public String getMagneticInterference() {
        return magneticInterference;
    }

    public void setMagneticInterference(String magneticInterference) {
        this.magneticInterference = magneticInterference;
    }

    public String getLowLithiumBattery() {
        return lowLithiumBattery;
    }

    public void setLowLithiumBattery(String lowLithiumBattery) {
        this.lowLithiumBattery = lowLithiumBattery;
    }

    public String getLostLithiumBattery() {
        return lostLithiumBattery;
    }

    public void setLostLithiumBattery(String lostLithiumBattery) {
        this.lostLithiumBattery = lostLithiumBattery;
    }

    public String getInLowLithiumBattery() {
        return inLowLithiumBattery;
    }

    public void setInLowLithiumBattery(String inLowLithiumBattery) {
        this.inLowLithiumBattery = inLowLithiumBattery;
    }

    public String getMeterDebitAmt() {
        return meterDebitAmt;
    }

    public void setMeterDebitAmt(String meterDebitAmt) {
        this.meterDebitAmt = meterDebitAmt;
    }

    public String getUploadType() {
        return uploadType;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public String getNetworkShutValve() {
        return networkShutValve;
    }

    public void setNetworkShutValve(String networkShutValve) {
        this.networkShutValve = networkShutValve;
    }

    public String getSnr() {
        return snr;
    }

    public void setSnr(String snr) {
        this.snr = snr;
    }

    public String getMeasurementType() {
        return measurementType;
    }

    public void setMeasurementType(String measurementType) {
        this.measurementType = measurementType;
    }

    public String getOperatingModeFlow() {
        return operatingModeFlow;
    }

    public void setOperatingModeFlow(String operatingModeFlow) {
        this.operatingModeFlow = operatingModeFlow;
    }

    public String getStandardConditionFlow() {
        return standardConditionFlow;
    }

    public void setStandardConditionFlow(String standardConditionFlow) {
        this.standardConditionFlow = standardConditionFlow;
    }

    public String getFactoryCurrentSpeed() {
        return factoryCurrentSpeed;
    }

    public void setFactoryCurrentSpeed(String factoryCurrentSpeed) {
        this.factoryCurrentSpeed = factoryCurrentSpeed;
    }

    public String getStandardCurrentSpeed() {
        return standardCurrentSpeed;
    }

    public void setStandardCurrentSpeed(String standardCurrentSpeed) {
        this.standardCurrentSpeed = standardCurrentSpeed;
    }

    public String getOperatingModeTotal() {
        return operatingModeTotal;
    }

    public void setOperatingModeTotal(String operatingModeTotal) {
        this.operatingModeTotal = operatingModeTotal;
    }

    public String getStandardConditionTotal() {
        return standardConditionTotal;
    }

    public void setStandardConditionTotal(String standardConditionTotal) {
        this.standardConditionTotal = standardConditionTotal;
    }

    public String getLeakageFlag() {
        return leakageFlag;
    }

    public void setLeakageFlag(String leakageFlag) {
        this.leakageFlag = leakageFlag;
    }

    public String getGasLeakage() {
        return gasLeakage;
    }

    public void setGasLeakage(String gasLeakage) {
        this.gasLeakage = gasLeakage;
    }

    public String getAbnormalFlow() {
        return abnormalFlow;
    }

    public void setAbnormalFlow(String abnormalFlow) {
        this.abnormalFlow = abnormalFlow;
    }

    public String getIsTilt() {
        return isTilt;
    }

    public void setIsTilt(String isTilt) {
        this.isTilt = isTilt;
    }

    public String getPulseDisconnection() {
        return pulseDisconnection;
    }

    public void setPulseDisconnection(String pulseDisconnection) {
        this.pulseDisconnection = pulseDisconnection;
    }

    public String getReedSwitchException() {
        return reedSwitchException;
    }

    public void setReedSwitchException(String reedSwitchException) {
        this.reedSwitchException = reedSwitchException;
    }

    public String getTimesException() {
        return timesException;
    }

    public void setTimesException(String timesException) {
        this.timesException = timesException;
    }

    public String getLackOfGasFlag() {
        return lackOfGasFlag;
    }

    public void setLackOfGasFlag(String lackOfGasFlag) {
        this.lackOfGasFlag = lackOfGasFlag;
    }

    public String getSplitAlarm() {
        return splitAlarm;
    }

    public void setSplitAlarm(String splitAlarm) {
        this.splitAlarm = splitAlarm;
    }

    public String getExternalAlarm() {
        return externalAlarm;
    }

    public void setExternalAlarm(String externalAlarm) {
        this.externalAlarm = externalAlarm;
    }

    public String getSplitAlarmDate() {
        return splitAlarmDate;
    }

    public void setSplitAlarmDate(String splitAlarmDate) {
        this.splitAlarmDate = splitAlarmDate;
    }

    public String getXTIpllStopFlag() {
        return XTIpllStopFlag;
    }

    public void setXTIpllStopFlag(String XTIpllStopFlag) {
        this.XTIpllStopFlag = XTIpllStopFlag;
    }

    public String getDieMeter() {
        return dieMeter;
    }

    public void setDieMeter(String dieMeter) {
        this.dieMeter = dieMeter;
    }

    public String getDieMeter2() {
        return dieMeter2;
    }

    public void setDieMeter2(String dieMeter2) {
        this.dieMeter2 = dieMeter2;
    }

    public String getValveException() {
        return valveException;
    }

    public void setValveException(String valveException) {
        this.valveException = valveException;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", MeterRead.class.getSimpleName() + "[", "]")
                .add("tableBase=" + tableBase)
                .add("meterBalance=" + meterBalance)
                .add("meterPrice=" + meterPrice)
                .add("rechargeTimes=" + rechargeTimes)
                .add("voltage='" + voltage + "'")
                .add("batteryVoltage='" + batteryVoltage + "'")
                .add("signalStrength='" + signalStrength + "'")
                .add("powerLevel='" + powerLevel + "'")
                .add("valveState='" + valveState + "'")
                .add("magneticInterference='" + magneticInterference + "'")
                .add("lowLithiumBattery='" + lowLithiumBattery + "'")
                .add("lostLithiumBattery='" + lostLithiumBattery + "'")
                .add("inLowLithiumBattery='" + inLowLithiumBattery + "'")
                .add("meterDebitAmt='" + meterDebitAmt + "'")
                .add("uploadType='" + uploadType + "'")
                .add("networkShutValve='" + networkShutValve + "'")
                .add("snr='" + snr + "'")
                .add("measurementType='" + measurementType + "'")
                .add("operatingModeFlow='" + operatingModeFlow + "'")
                .add("standardConditionFlow='" + standardConditionFlow + "'")
                .add("factoryCurrentSpeed='" + factoryCurrentSpeed + "'")
                .add("standardCurrentSpeed='" + standardCurrentSpeed + "'")
                .add("operatingModeTotal='" + operatingModeTotal + "'")
                .add("standardConditionTotal='" + standardConditionTotal + "'")
                .add("leakageFlag='" + leakageFlag + "'")
                .add("gasLeakage='" + gasLeakage + "'")
                .add("abnormalFlow='" + abnormalFlow + "'")
                .add("isTilt='" + isTilt + "'")
                .add("pulseDisconnection='" + pulseDisconnection + "'")
                .add("reedSwitchException='" + reedSwitchException + "'")
                .add("timesException='" + timesException + "'")
                .add("lackOfGasFlag='" + lackOfGasFlag + "'")
                .add("splitAlarm='" + splitAlarm + "'")
                .add("externalAlarm='" + externalAlarm + "'")
                .add("splitAlarmDate='" + splitAlarmDate + "'")
                .add("XTIpllStopFlag='" + XTIpllStopFlag + "'")
                .add("dieMeter='" + dieMeter + "'")
                .add("dieMeter2='" + dieMeter2 + "'")
                .add("valveException='" + valveException + "'")
                .toString();
    }
}
